/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.type.value;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class AnnotatedValue<T> {
    private T value;
    private String label;
    private String description;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();

    protected AnnotatedValue() {
    }

    public AnnotatedValue(T value, String label, String description, Map<String, Object> features) {
        this.value = value;
        this.label = label;
        this.description = description;
        this.features = features;
    }

    public AnnotatedValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = new LinkedHashMap<String, Object>(features);
    }

    public AnnotatedValue<T> withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public AnnotatedValue<T> withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public AnnotatedValue<T> withFeatures(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public AnnotatedValue<T> withFeature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }
}

