/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.util;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.QualifiedDataType;
import org.openksavi.sponge.type.RecordType;
import org.openksavi.sponge.type.value.AnnotatedValue;

public abstract class DataTypeUtils {
    private DataTypeUtils() {
    }

    public static void traverseDataType(QualifiedDataType qualifiedType, Consumer<QualifiedDataType> onType, boolean namedOnly) {
        if (namedOnly && qualifiedType.getType().getName() == null) {
            return;
        }
        onType.accept(qualifiedType);
        switch (qualifiedType.getType().getKind()) {
            case RECORD: {
                ((RecordType)qualifiedType.getType()).getFields().forEach(field -> DataTypeUtils.traverseDataType(qualifiedType.createChild(field), onType, namedOnly));
                break;
            }
        }
    }

    public static <P> P getFeatureOrProperty(DataType type, Object value, String propertyName, Supplier<P> orElse) {
        Object property = null;
        if (value instanceof AnnotatedValue) {
            property = ((AnnotatedValue)value).getFeatures().get(propertyName);
        }
        if (property == null) {
            property = type.getFeatures().get(propertyName);
        }
        return (P)(property != null ? property : orElse.get());
    }

    public static Set<String> getRegisteredTypeNames(DataType type) {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        DataTypeUtils.traverseDataType(new QualifiedDataType(type), qType -> {
            RecordType recordType;
            if (qType.getType().getRegisteredType() != null) {
                types.add(qType.getType().getRegisteredType());
            }
            if (qType.getType() instanceof RecordType && (recordType = (RecordType)qType.getType()).getBaseType() != null) {
                types.addAll(DataTypeUtils.getRegisteredTypeNames(recordType.getBaseType()));
            }
        }, false);
        return types;
    }
}

