/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.util;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.action.ActionMeta;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.QualifiedDataType;
import org.openksavi.sponge.type.RecordType;
import org.openksavi.sponge.type.value.AnnotatedValue;
import org.openksavi.sponge.util.DataTypeUtils;
import org.openksavi.sponge.util.ValueHolder;

public abstract class SpongeApiUtils {
    private SpongeApiUtils() {
    }

    public static int getActionArgIndex(List<DataType> argTypes, String argName) {
        if (argTypes != null) {
            for (int i = 0; i < argTypes.size(); ++i) {
                if (!argTypes.get(i).getName().equals(argName)) continue;
                return i;
            }
        }
        return -1;
    }

    public static DataType getActionArgType(List<DataType> argTypes, String argName) {
        Validate.notNull(argTypes, (String)"Arguments not defined", (Object[])new Object[0]);
        List<String> elements = SpongeApiUtils.getActionArgNameElements(argName);
        ValueHolder<DataType> argTypeHolder = new ValueHolder<DataType>(argTypes.get(SpongeApiUtils.getActionArgIndex(argTypes, elements.get(0))));
        elements.stream().skip(1L).limit(elements.size() - 1).forEach(element -> {
            DataType argType = (DataType)argTypeHolder.getValue();
            Validate.notNull(argTypeHolder.getValue(), (String)"Argument '%s' not found", (Object[])new Object[]{argName});
            Validate.notNull((Object)argType.getName(), (String)"The sub-type nas no name", (Object[])new Object[0]);
            Validate.isTrue((boolean)(argType instanceof RecordType), (String)"The element %s is not a record", (Object[])new Object[]{argType.getName()});
            argTypeHolder.setValue(((RecordType)argType).getFields().stream().filter(fieldType -> fieldType.getName().equals(element)).findFirst().orElse(null));
        });
        return argTypeHolder.getValue();
    }

    public static Map<String, DataType> createNamedActionArgTypesMap(ActionMeta actionMeta) {
        LinkedHashMap<String, DataType> argTypesMap = new LinkedHashMap<String, DataType>();
        SpongeApiUtils.traverseActionArguments(actionMeta, qualifiedType -> argTypesMap.put(qualifiedType.getPath(), qualifiedType.getType()), true);
        return argTypesMap;
    }

    public static List<String> getActionArgNameElements(String name) {
        return Arrays.asList(name.split("\\."));
    }

    public static void traverseActionArguments(ActionMeta actionMeta, Consumer<QualifiedDataType> onType, boolean namedOnly) {
        if (actionMeta.getArgs() != null) {
            actionMeta.getArgs().forEach(argType -> DataTypeUtils.traverseDataType(new QualifiedDataType(argType.getName(), argType), onType, namedOnly));
        }
    }

    public static <K1, V1, K2, V2> Map<K2, V2> collectToLinkedMap(Map<K1, V1> source, Function<Map.Entry<K1, V1>, ? extends K2> keyMapper, Function<Map.Entry<K1, V1>, ? extends V2> valueMapper) {
        if (source == null) {
            return null;
        }
        LinkedHashMap result = new LinkedHashMap();
        source.entrySet().forEach(entry -> result.put(keyMapper.apply((Map.Entry)entry), valueMapper.apply((Map.Entry)entry)));
        return result;
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> collectorToLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new);
    }

    public static <T> List<T> unwrapAnnotatedValueList(List<AnnotatedValue<T>> annotatedValueList) {
        return annotatedValueList != null ? annotatedValueList.stream().map(annotatedValue -> annotatedValue != null ? annotatedValue.getValue() : null).collect(Collectors.toList()) : null;
    }

    public static List<?> unwrapUnknownAnnotatedValueList(List<AnnotatedValue> annotatedValueList) {
        return annotatedValueList != null ? annotatedValueList.stream().map(annotatedValue -> annotatedValue != null ? annotatedValue.getValue() : null).collect(Collectors.toList()) : null;
    }
}

