/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.action;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.type.DataType;

public class IsActionActiveContext
implements Cloneable {
    private Object value;
    private DataType type;
    private List<Object> args;
    private Map<String, Object> features;

    public IsActionActiveContext(Object value, DataType type, List<Object> args, Map<String, Object> features) {
        this.value = value;
        this.type = type;
        this.args = args;
        this.features = features;
    }

    public IsActionActiveContext(Object value, DataType type, List<Object> args) {
        this(value, type, args, new LinkedHashMap<String, Object>());
    }

    public IsActionActiveContext(List<Object> args) {
        this(null, null, args);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public void setArgs(List<Object> args) {
        this.args = args;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = features;
    }

    public Object getFeature(String featureName) {
        Validate.notNull(this.features, (String)"There are no feature set", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.features.containsKey(featureName), (String)"There is no feature %s", (Object[])new Object[]{featureName});
        return this.features.get(featureName);
    }

    public <T> T getFeature(String featureName, T defaultValue) {
        if (this.features == null || !this.features.containsKey(featureName)) {
            return defaultValue;
        }
        return (T)this.features.get(featureName);
    }

    public IsActionActiveContext clone() {
        try {
            IsActionActiveContext cloned = (IsActionActiveContext)super.clone();
            cloned.args = this.args != null ? new ArrayList<Object>(this.args) : null;
            cloned.features = this.features != null ? new LinkedHashMap<String, Object>(this.features) : null;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException(e);
        }
    }
}

