/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.type.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openksavi.sponge.type.value.DecoratedValue;

public class AnnotatedValue<T>
implements DecoratedValue<T> {
    public static Set<String> FIELDS = new LinkedHashSet<String>(Arrays.asList("value", "valueLabel", "valueDescription", "features", "typeLabel", "typeDescription"));
    private T value;
    private String valueLabel;
    private String valueDescription;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();
    private String typeLabel;
    private String typeDescription;

    protected AnnotatedValue() {
    }

    public AnnotatedValue(T value, String valueLabel, String valueDescription, Map<String, Object> features, String typeLabel, String typeDescription) {
        this.value = value;
        this.valueLabel = valueLabel;
        this.valueDescription = valueDescription;
        this.features = features;
        this.typeLabel = typeLabel;
        this.typeDescription = typeDescription;
    }

    public AnnotatedValue(T value) {
        this.value = value;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    public String getValueLabel() {
        return this.valueLabel;
    }

    public void setValueLabel(String valueLabel) {
        this.valueLabel = valueLabel;
    }

    public String getValueDescription() {
        return this.valueDescription;
    }

    public void setValueDescription(String valueDescription) {
        this.valueDescription = valueDescription;
    }

    public Map<String, Object> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = new LinkedHashMap<String, Object>(features);
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public void setTypeLabel(String typeLabel) {
        this.typeLabel = typeLabel;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public void setTypeDescription(String typeDescription) {
        this.typeDescription = typeDescription;
    }

    public AnnotatedValue<T> withValueLabel(String valueLabel) {
        this.setValueLabel(valueLabel);
        return this;
    }

    public AnnotatedValue<T> withValueDescription(String valueDescription) {
        this.setValueDescription(valueDescription);
        return this;
    }

    public AnnotatedValue<T> withFeatures(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public AnnotatedValue<T> withFeature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }

    public AnnotatedValue<T> withTypeLabel(String typeLabel) {
        this.setTypeLabel(typeLabel);
        return this;
    }

    public AnnotatedValue<T> withTypeDescription(String typeDescription) {
        this.setTypeDescription(typeDescription);
        return this;
    }
}

