/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.ListType;
import org.openksavi.sponge.type.MapType;
import org.openksavi.sponge.type.ObjectType;
import org.openksavi.sponge.type.QualifiedDataType;
import org.openksavi.sponge.type.RecordType;
import org.openksavi.sponge.type.value.AnnotatedValue;

public abstract class DataTypeUtils {
    private DataTypeUtils() {
    }

    public static void traverseDataType(QualifiedDataType qualifiedType, Consumer<QualifiedDataType> onType, boolean namedOnly, boolean traverseCollections) {
        if (namedOnly && qualifiedType.getType().getName() == null) {
            return;
        }
        onType.accept(qualifiedType);
        ArrayList<QualifiedDataType<Object>> subTypes = new ArrayList<QualifiedDataType<Object>>();
        switch (qualifiedType.getType().getKind()) {
            case RECORD: {
                ((RecordType)qualifiedType.getType()).getFields().forEach(field -> subTypes.add(qualifiedType.createChild(field)));
                break;
            }
            case LIST: {
                if (!traverseCollections) break;
                DataType elementType = ((ListType)qualifiedType.getType()).getElementType();
                subTypes.add(new QualifiedDataType(qualifiedType.getPath() != null && elementType.getName() != null ? qualifiedType.getPath() + "." + elementType.getName() : null, elementType));
                break;
            }
            case MAP: {
                if (!traverseCollections) break;
                DataType keyType = ((MapType)qualifiedType.getType()).getKeyType();
                DataType valueType = ((MapType)qualifiedType.getType()).getValueType();
                subTypes.add(new QualifiedDataType(qualifiedType.getPath() != null && keyType.getName() != null ? qualifiedType.getPath() + "." + keyType.getName() : null, keyType));
                subTypes.add(new QualifiedDataType(qualifiedType.getPath() != null && valueType.getName() != null ? qualifiedType.getPath() + "." + valueType.getName() : null, valueType));
                break;
            }
            case OBJECT: {
                ObjectType objectType = (ObjectType)qualifiedType.getType();
                if (objectType.getCompanionType() == null) break;
                subTypes.add(qualifiedType.createChild(objectType.getCompanionType()));
                break;
            }
        }
        subTypes.forEach(subType -> DataTypeUtils.traverseDataType(subType, onType, namedOnly, traverseCollections));
    }

    public static void traverseDataType(QualifiedDataType qualifiedType, Consumer<QualifiedDataType> onType) {
        DataTypeUtils.traverseDataType(qualifiedType, onType, true, false);
    }

    public static <P> P getFeatureOrProperty(DataType type, Object value, String propertyName, Supplier<P> orElse) {
        Object property = null;
        if (value instanceof AnnotatedValue) {
            property = ((AnnotatedValue)value).getFeatures().get(propertyName);
        }
        if (property == null) {
            property = type.getFeatures().get(propertyName);
        }
        return (P)(property != null ? property : orElse.get());
    }

    public static Set<String> getRegisteredTypeNames(DataType type) {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        DataTypeUtils.traverseDataType(new QualifiedDataType(type), qualifiedType -> {
            RecordType recordType;
            if (qualifiedType.getType().getRegisteredType() != null) {
                types.add(qualifiedType.getType().getRegisteredType());
            }
            if (qualifiedType.getType() instanceof RecordType && (recordType = (RecordType)qualifiedType.getType()).getBaseType() != null) {
                types.addAll(DataTypeUtils.getRegisteredTypeNames(recordType.getBaseType()));
            }
        }, false, true);
        return types;
    }

    public static boolean supportsElementValueSet(DataType<?> type) {
        return type instanceof ListType;
    }

    public static boolean isProvidedRead(DataType<?> type) {
        return type.getProvided() != null && (type.getProvided().isValue() || type.getProvided().getValueSet() != null || type.getProvided().isElementValueSet());
    }

    public static boolean isProvidedWrite(DataType<?> type) {
        return type.getProvided() != null && type.getProvided().isSubmittable();
    }

    public static List<DataType> getTypes(DataType type) {
        ArrayList<DataType> types = new ArrayList<DataType>();
        DataTypeUtils.traverseDataType(new QualifiedDataType(null, type), qualifiedType -> types.add(qualifiedType.getType()), false, true);
        return types;
    }
}

