/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.type;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.type.DataTypeKind;
import org.openksavi.sponge.type.provided.ProvidedMeta;
import org.openksavi.sponge.type.value.AnnotatedValue;
import org.openksavi.sponge.util.Descriptive;
import org.openksavi.sponge.util.HasFeatures;

public class DataType<T>
implements Descriptive,
HasFeatures,
Cloneable {
    public static final String FEATURE_FORMAT = "format";
    private DataTypeKind kind;
    private String registeredType;
    private String name;
    private String label;
    private String description;
    private boolean annotated = false;
    private String format;
    private Object defaultValue;
    private boolean nullable = false;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();
    private boolean optional = false;
    private ProvidedMeta provided;

    private DataType() {
    }

    protected DataType(DataTypeKind kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    public DataType<T> withName(String name) {
        this.name = name;
        return this;
    }

    public DataType<T> withLabel(String label) {
        this.label = label;
        return this;
    }

    public DataType<T> withDescription(String description) {
        this.description = description;
        return this;
    }

    public DataType<T> withAnnotated(boolean annotated) {
        this.annotated = annotated;
        return this;
    }

    public DataType<T> withAnnotated() {
        return this.withAnnotated(true);
    }

    public DataType<T> withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public DataType<T> withDefaultValue(T value) {
        this.setDefaultValue(value);
        return this;
    }

    public DataType<T> withDefaultValue(AnnotatedValue<T> value) {
        this.setDefaultValue(value);
        return this;
    }

    public DataType<T> withNullable(boolean nullable) {
        this.setNullable(nullable);
        return this;
    }

    public DataType<T> withNullable() {
        return this.withNullable(true);
    }

    public DataType<T> withFeatures(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public DataType<T> withFeature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }

    public DataType<T> withOptional() {
        this.optional = true;
        return this;
    }

    public DataType<T> withProvided(ProvidedMeta provided) {
        this.provided = provided;
        return this;
    }

    public DataTypeKind getKind() {
        return this.kind;
    }

    public String getRegisteredType() {
        return this.registeredType;
    }

    public void setRegisteredType(String registeredType) {
        this.registeredType = registeredType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean annotated) {
        this.annotated = annotated;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public Map<String, Object> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    @Override
    public void setFeatures(Map<String, Object> features) {
        this.features = new LinkedHashMap<String, Object>(features);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public ProvidedMeta getProvided() {
        return this.provided;
    }

    public void setProvided(ProvidedMeta provided) {
        this.provided = provided;
    }

    public DataType<T> clone() {
        try {
            DataType cloned = (DataType)super.clone();
            cloned.defaultValue = this.defaultValue instanceof Cloneable ? ObjectUtils.clone((Object)this.defaultValue) : this.defaultValue;
            cloned.features = this.features != null ? new LinkedHashMap<String, Object>(this.features) : null;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException(e);
        }
    }
}

