/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.engine;

import org.openksavi.sponge.SpongeException;

public class WrappedException
extends SpongeException {
    private static final long serialVersionUID = -7842020620067616297L;
    private static final String EXCEPTION_CLASS_MESSAGE_PREFIX_FORMAT = "%s: ";
    protected static final String WRAPPED_MESSAGE_PREFIX = String.format("%s: ", WrappedException.class.getName());
    private String sourceName;

    public WrappedException(String sourceName, Throwable throwable) {
        this(sourceName, throwable.getMessage(), throwable);
    }

    public WrappedException(String sourceName, String message, Throwable throwable) {
        super(WrappedException.getCoreExceptionMessage(message, throwable), throwable);
        this.sourceName = sourceName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + " at " + this.sourceName;
    }

    protected static String getCoreExceptionMessage(String message, Throwable e) {
        if (e == null) {
            return message;
        }
        if (message != null) {
            while (message.startsWith(WRAPPED_MESSAGE_PREFIX) && message.length() > WRAPPED_MESSAGE_PREFIX.length()) {
                message = message.substring(WRAPPED_MESSAGE_PREFIX.length());
            }
            String prefix = String.format(EXCEPTION_CLASS_MESSAGE_PREFIX_FORMAT, e.getClass().getName());
            while (message.startsWith(prefix) && message.length() > prefix.length()) {
                message = message.substring(prefix.length());
            }
        } else {
            message = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
        }
        return message;
    }

    public static String getCoreExceptionMessage(Throwable e) {
        return WrappedException.getCoreExceptionMessage(e.getMessage(), e);
    }
}

