/*
 * Copyright 2016-2019 The Sponge authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.openksavi.sponge;

import java.time.Duration;
import java.util.List;
import java.util.Map;

/**
 * An event set processor builder.
 */
public interface EventSetProcessorBuilder<T extends EventSetProcessor<?>> extends EventProcessorBuilder<T> {

    @Override
    EventSetProcessorBuilder<T> withName(String name);

    @Override
    EventSetProcessorBuilder<T> withLabel(String label);

    @Override
    EventSetProcessorBuilder<T> withDescription(String description);

    @Override
    EventSetProcessorBuilder<T> withVersion(Integer version);

    @Override
    EventSetProcessorBuilder<T> withFeatures(Map<String, Object> features);

    @Override
    EventSetProcessorBuilder<T> withFeature(String name, Object value);

    @Override
    EventSetProcessorBuilder<T> withCategory(String category);

    @Override
    EventSetProcessorBuilder<T> withOnInit(ProcessorOnInitCallback<T> onInitCallback);

    @Override
    EventSetProcessorBuilder<T> withEvents(List<String> eventNames);

    @Override
    EventSetProcessorBuilder<T> withEvent(String eventName);

    EventSetProcessorBuilder<T> withDuration(Duration duration);

    EventSetProcessorBuilder<T> withSynchronous(Boolean synchronous);
}
