/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.util.process;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.util.process.ErrorRedirect;
import org.openksavi.sponge.util.process.InputRedirect;
import org.openksavi.sponge.util.process.OutputRedirect;
import org.openksavi.sponge.util.process.ProcessConfiguration;
import org.openksavi.sponge.util.process.ProcessInstance;
import org.slf4j.Logger;

public class ProcessInstanceBuilder {
    private SpongeEngine engine;
    private ProcessConfiguration configuration;

    public ProcessInstanceBuilder(SpongeEngine engine, String executable) {
        this(engine, new ProcessConfiguration(executable));
    }

    public ProcessInstanceBuilder(SpongeEngine engine, ProcessConfiguration configuration) {
        this.engine = engine;
        this.configuration = configuration;
    }

    public ProcessConfiguration getConfiguration() {
        return this.configuration;
    }

    public ProcessInstance build() {
        return this.engine.createProcessInstance(this.configuration);
    }

    public ProcessInstance run() throws InterruptedException {
        return this.build().run();
    }

    public ProcessInstance runAsync() throws InterruptedException {
        return this.build().runAsync();
    }

    public ProcessInstanceBuilder name(String name) {
        this.configuration.setName(name);
        return this;
    }

    public ProcessInstanceBuilder arguments(String ... arguments) {
        this.arguments(Arrays.asList(arguments));
        return this;
    }

    public ProcessInstanceBuilder arguments(List<String> arguments) {
        this.configuration.getArguments().addAll(arguments.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        return this;
    }

    public ProcessInstanceBuilder workingDir(String workingDir) {
        this.configuration.setWorkingDir(workingDir);
        return this;
    }

    public ProcessInstanceBuilder env(String name, String value) {
        this.configuration.getEnv().put(name, value);
        return this;
    }

    public ProcessInstanceBuilder env(Map<String, String> env) {
        this.configuration.getEnv().putAll(env);
        return this;
    }

    public ProcessInstanceBuilder waitSeconds(Long waitSeconds) {
        this.configuration.setWaitSeconds(waitSeconds);
        return this;
    }

    public ProcessInstanceBuilder inputRedirect(InputRedirect inputRedirect) {
        this.configuration.setInputRedirect(inputRedirect);
        return this;
    }

    public ProcessInstanceBuilder outputRedirect(OutputRedirect outputRedirect) {
        this.configuration.setOutputRedirect(outputRedirect);
        return this;
    }

    public ProcessInstanceBuilder errorRedirect(ErrorRedirect errorRedirect) {
        this.configuration.setErrorRedirect(errorRedirect);
        return this;
    }

    public ProcessInstanceBuilder charset(Charset charset) {
        this.configuration.setCharset(charset);
        return this;
    }

    public ProcessInstanceBuilder waitForPositiveLineRegexp(String waitForPositiveLineRegexp) {
        this.configuration.setWaitForPositiveLineRegexp(waitForPositiveLineRegexp);
        return this;
    }

    public ProcessInstanceBuilder waitForNegativeLineRegexp(String waitForNegativeLineRegexp) {
        this.configuration.setWaitForNegativeLineRegexp(waitForNegativeLineRegexp);
        return this;
    }

    public ProcessInstanceBuilder waitForLineTimeout(Long waitForLineTimeout) {
        this.configuration.setWaitForLineTimeout(waitForLineTimeout);
        return this;
    }

    public ProcessInstanceBuilder outputLoggingConsumer(BiConsumer<Logger, String> outputLoggingConsumer) {
        this.configuration.setOutputLoggingConsumer(outputLoggingConsumer);
        return this;
    }

    public ProcessInstanceBuilder outputLoggingConsumerNone() {
        return this.outputLoggingConsumer((logger, line) -> {});
    }

    public ProcessInstanceBuilder errorLoggingConsumer(BiConsumer<Logger, String> errorLoggingConsumer) {
        this.configuration.setErrorLoggingConsumer(errorLoggingConsumer);
        return this;
    }

    public ProcessInstanceBuilder inheritIo() {
        return this.inputRedirect(InputRedirect.INHERIT).outputRedirect(OutputRedirect.INHERIT).errorRedirect(ErrorRedirect.INHERIT);
    }

    public ProcessInstanceBuilder processBuilderConsumer(Consumer<ProcessBuilder> processBuilderConsumer) {
        this.configuration.setProcessBuilderConsumer(processBuilderConsumer);
        return this;
    }

    public ProcessInstanceBuilder redirectErrorStream(boolean redirectErrorStream) {
        this.configuration.setRedirectErrorStream(redirectErrorStream);
        return this;
    }

    public ProcessInstanceBuilder exceptionOnExitCode(boolean exceptionOnExitCode) {
        this.configuration.setExceptionOnExitCode(exceptionOnExitCode);
        return this;
    }

    public ProcessInstanceBuilder inputAsInherit() {
        return this.inputRedirect(InputRedirect.INHERIT);
    }

    public ProcessInstanceBuilder inputAsString(String inputString) {
        this.configuration.setInputRedirect(InputRedirect.STRING);
        this.configuration.setInputString(inputString);
        return this;
    }

    public ProcessInstanceBuilder inputAsBinary(byte[] inputBinary) {
        this.configuration.setInputRedirect(InputRedirect.BINARY);
        this.configuration.setInputBinary(inputBinary);
        return this;
    }

    public ProcessInstanceBuilder inputAsFile(String inputFile) {
        this.configuration.setInputRedirect(InputRedirect.FILE);
        this.configuration.setInputFile(inputFile);
        return this;
    }

    public ProcessInstanceBuilder inputAsStream() {
        return this.inputRedirect(InputRedirect.STREAM);
    }

    public ProcessInstanceBuilder outputAsInherit() {
        return this.outputRedirect(OutputRedirect.INHERIT);
    }

    public ProcessInstanceBuilder outputAsString() {
        return this.outputRedirect(OutputRedirect.STRING);
    }

    public ProcessInstanceBuilder outputAsBinary() {
        return this.outputRedirect(OutputRedirect.BINARY);
    }

    public ProcessInstanceBuilder outputAsFile(String outputFile) {
        this.configuration.setOutputRedirect(OutputRedirect.FILE);
        this.configuration.setOutputFile(outputFile);
        return this;
    }

    public ProcessInstanceBuilder outputAsConsumer(Consumer<String> outputLineConsumer) {
        this.configuration.setOutputRedirect(OutputRedirect.CONSUMER);
        this.configuration.setOutputLineConsumer(outputLineConsumer);
        return this;
    }

    public ProcessInstanceBuilder outputAsConsumer() {
        return this.outputRedirect(OutputRedirect.CONSUMER);
    }

    public ProcessInstanceBuilder errorAsInherit() {
        return this.errorRedirect(ErrorRedirect.INHERIT);
    }

    public ProcessInstanceBuilder errorAsString() {
        return this.errorRedirect(ErrorRedirect.STRING);
    }

    public ProcessInstanceBuilder errorAsFile(String errorFile) {
        this.configuration.setErrorRedirect(ErrorRedirect.FILE);
        this.configuration.setErrorFile(errorFile);
        return this;
    }

    public ProcessInstanceBuilder errorAsException() {
        return this.errorRedirect(ErrorRedirect.EXCEPTION);
    }

    public ProcessInstanceBuilder errorAsConsumer() {
        return this.errorRedirect(ErrorRedirect.CONSUMER);
    }

    public ProcessInstanceBuilder errorAsConsumer(Consumer<String> errorLineConsumer) {
        this.configuration.setErrorRedirect(ErrorRedirect.CONSUMER);
        this.configuration.setErrorLineConsumer(errorLineConsumer);
        return this;
    }
}

