/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.action;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.provided.ProvidedValue;

public class ProvideArgsContext {
    private Set<String> provide;
    private Set<String> submit;
    private Map<String, Object> current;
    private Map<String, ProvidedValue<?>> provided;
    private Map<String, DataType> dynamicTypes;
    private Map<String, Map<String, Object>> argFeatures;
    private boolean initial;

    public ProvideArgsContext(Set<String> provide, Set<String> submit, Map<String, Object> current, Map<String, ProvidedValue<?>> provided, Map<String, DataType> dynamicTypes, Map<String, Map<String, Object>> argFeatures, boolean initial) {
        this.provide = provide;
        this.submit = submit;
        this.current = current;
        this.provided = provided;
        this.dynamicTypes = dynamicTypes;
        this.argFeatures = argFeatures;
        this.initial = initial;
    }

    public Set<String> getProvide() {
        return this.provide;
    }

    public void setProvide(Set<String> provide) {
        this.provide = provide;
    }

    public Set<String> getSubmit() {
        return this.submit;
    }

    public void setSubmit(Set<String> submit) {
        this.submit = submit;
    }

    public Map<String, Object> getCurrent() {
        return this.current;
    }

    public void setCurrent(Map<String, Object> current) {
        this.current = current;
    }

    public Map<String, ProvidedValue<?>> getProvided() {
        return this.provided;
    }

    public void setProvided(Map<String, ProvidedValue<?>> provided) {
        this.provided = provided;
    }

    public Map<String, DataType> getDynamicTypes() {
        return this.dynamicTypes;
    }

    public void setDynamicTypes(Map<String, DataType> dynamicTypes) {
        this.dynamicTypes = dynamicTypes;
    }

    public Map<String, Map<String, Object>> getArgFeatures() {
        return this.argFeatures;
    }

    public void setArgFeatures(Map<String, Map<String, Object>> argFeatures) {
        this.argFeatures = argFeatures;
    }

    public Object getArgFeature(String argName, String featureName) {
        Validate.notNull(this.argFeatures, (String)"Argument features not set", (Object[])new Object[0]);
        Map<String, Object> features = this.argFeatures.get(argName);
        Validate.notNull(features, (String)"There are no features for argument %s", (Object[])new Object[]{argName});
        Validate.isTrue((boolean)features.containsKey(featureName), (String)"There is no feature %s for argument %s", (Object[])new Object[]{featureName, argName});
        return features.get(featureName);
    }

    public <T> T getArgFeature(String argName, String featureName, T defaultValue) {
        if (this.argFeatures == null || this.argFeatures.get(argName) == null || !this.argFeatures.get(argName).containsKey(featureName)) {
            return defaultValue;
        }
        return (T)this.argFeatures.get(argName).get(featureName);
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }
}

