/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.type;

import java.time.temporal.Temporal;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.DataTypeKind;
import org.openksavi.sponge.type.DateTimeKind;
import org.openksavi.sponge.type.provided.ProvidedMeta;

public class DateTimeType
extends DataType<Object> {
    public static final String FEATURE_DATE_TIME_KIND = "dateTimeKind";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-dd-MM";
    private DateTimeKind dateTimeKind;
    private Object minValue;
    private Object maxValue;

    public DateTimeType() {
        this(null);
    }

    public DateTimeType(String name) {
        this(name, DateTimeKind.DATE_TIME);
    }

    public DateTimeType(String name, DateTimeKind dateTimeKind) {
        super(DataTypeKind.DATE_TIME, name);
        this.dateTimeKind = dateTimeKind;
        this.updateFormat();
    }

    public DateTimeType withName(String name) {
        return (DateTimeType)super.withName(name);
    }

    public DateTimeType withLabel(String label) {
        return (DateTimeType)super.withLabel(label);
    }

    public DateTimeType withDescription(String description) {
        return (DateTimeType)super.withDescription(description);
    }

    public DateTimeType withAnnotated(boolean annotated) {
        return (DateTimeType)super.withAnnotated(annotated);
    }

    public DateTimeType withAnnotated() {
        return (DateTimeType)super.withAnnotated();
    }

    public DateTimeType withFormat(String format) {
        return (DateTimeType)super.withFormat(format);
    }

    public DateTimeType withFeatures(Map<String, Object> features) {
        return (DateTimeType)super.withFeatures(features);
    }

    public DateTimeType withFeature(String name, Object value) {
        return (DateTimeType)super.withFeature(name, value);
    }

    public DateTimeType withDefaultValue(Object value) {
        Validate.isTrue((value == null || value instanceof Temporal ? 1 : 0) != 0, (String)"The DateTimeType default value has to be an instance of Temporal", (Object[])new Object[0]);
        return (DateTimeType)super.withDefaultValue(value);
    }

    public DateTimeType withNullable(boolean nullable) {
        return (DateTimeType)super.withNullable(nullable);
    }

    public DateTimeType withNullable() {
        return (DateTimeType)super.withNullable();
    }

    public DateTimeType withReadOnly(boolean readOnly) {
        return (DateTimeType)super.withReadOnly(readOnly);
    }

    public DateTimeType withReadOnly() {
        return (DateTimeType)super.withReadOnly();
    }

    public DateTimeType withOptional() {
        return (DateTimeType)super.withOptional();
    }

    public DateTimeType withProvided(ProvidedMeta provided) {
        return (DateTimeType)super.withProvided(provided);
    }

    public DateTimeKind getDateTimeKind() {
        return this.dateTimeKind;
    }

    public void setDateTimeKind(DateTimeKind dateTimeKind) {
        this.dateTimeKind = dateTimeKind;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Object minValue) {
        this.minValue = minValue;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }

    public DateTimeType withDateTimeKind(DateTimeKind dateTimeKind) {
        this.setDateTimeKind(dateTimeKind);
        this.updateFormat();
        return this;
    }

    public DateTimeType withDateTime() {
        return this.withDateTimeKind(DateTimeKind.DATE_TIME);
    }

    public DateTimeType withDateTimeZone() {
        return this.withDateTimeKind(DateTimeKind.DATE_TIME_ZONE);
    }

    public DateTimeType withDate() {
        return this.withDateTimeKind(DateTimeKind.DATE);
    }

    public DateTimeType withTime() {
        return this.withDateTimeKind(DateTimeKind.TIME);
    }

    public DateTimeType withInstant() {
        return this.withDateTimeKind(DateTimeKind.INSTANT);
    }

    public DateTimeType withMinValue(Temporal minValue) {
        this.setMinValue(minValue);
        return this;
    }

    public DateTimeType withMaxValue(Temporal maxValue) {
        this.setMaxValue(maxValue);
        return this;
    }

    private void updateFormat() {
        if (this.getFormat() == null) {
            switch (this.dateTimeKind) {
                case DATE: {
                    this.setFormat(DEFAULT_DATE_FORMAT);
                    break;
                }
            }
        }
    }
}

