/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.util.process;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.util.process.ErrorRedirect;
import org.openksavi.sponge.util.process.InputRedirect;
import org.openksavi.sponge.util.process.OutputRedirect;
import org.slf4j.Logger;

public class ProcessConfiguration
implements Cloneable {
    private String name;
    private String executable;
    private List<String> arguments = new ArrayList<String>();
    private String workingDir;
    private Map<String, String> env = new LinkedHashMap<String, String>();
    private Long waitSeconds;
    private InputRedirect inputRedirect = InputRedirect.PIPE;
    private OutputRedirect outputRedirect = OutputRedirect.PIPE;
    private ErrorRedirect errorRedirect = ErrorRedirect.PIPE;
    private Charset charset;
    private String waitForPositiveLineRegexp;
    private String waitForNegativeLineRegexp;
    private Long waitForLineTimeout;
    private String inputString;
    private byte[] inputBinary;
    private String inputFile;
    private String outputFile;
    private String errorFile;
    private Consumer<String> outputLineConsumer;
    private Consumer<String> errorLineConsumer;
    private BiConsumer<Logger, String> outputLoggingConsumer;
    private BiConsumer<Logger, String> errorLoggingConsumer;
    private Consumer<ProcessBuilder> processBuilderConsumer;
    public boolean redirectErrorStream = false;
    public boolean exceptionOnExitCode = true;

    public ProcessConfiguration(String executable) {
        this.executable = executable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Long getWaitSeconds() {
        return this.waitSeconds;
    }

    public void setWaitSeconds(Long waitSeconds) {
        this.waitSeconds = waitSeconds;
    }

    public InputRedirect getInputRedirect() {
        return this.inputRedirect;
    }

    public void setInputRedirect(InputRedirect inputRedirect) {
        this.inputRedirect = inputRedirect;
    }

    public OutputRedirect getOutputRedirect() {
        return this.outputRedirect;
    }

    public void setOutputRedirect(OutputRedirect outputRedirect) {
        this.outputRedirect = outputRedirect;
    }

    public ErrorRedirect getErrorRedirect() {
        return this.errorRedirect;
    }

    public void setErrorRedirect(ErrorRedirect errorRedirect) {
        this.errorRedirect = errorRedirect;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getWaitForPositiveLineRegexp() {
        return this.waitForPositiveLineRegexp;
    }

    public void setWaitForPositiveLineRegexp(String waitForPositiveLineRegexp) {
        this.waitForPositiveLineRegexp = waitForPositiveLineRegexp;
    }

    public String getWaitForNegativeLineRegexp() {
        return this.waitForNegativeLineRegexp;
    }

    public void setWaitForNegativeLineRegexp(String waitForNegativeLineRegexp) {
        this.waitForNegativeLineRegexp = waitForNegativeLineRegexp;
    }

    public Long getWaitForLineTimeout() {
        return this.waitForLineTimeout;
    }

    public void setWaitForLineTimeout(Long waitForLineTimeout) {
        this.waitForLineTimeout = waitForLineTimeout;
    }

    public String getInputString() {
        return this.inputString;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    public byte[] getInputBinary() {
        return this.inputBinary;
    }

    public void setInputBinary(byte[] inputBinary) {
        this.inputBinary = inputBinary;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getErrorFile() {
        return this.errorFile;
    }

    public void setErrorFile(String errorFile) {
        this.errorFile = errorFile;
    }

    public Consumer<String> getOutputLineConsumer() {
        return this.outputLineConsumer;
    }

    public void setOutputLineConsumer(Consumer<String> outputLineConsumer) {
        this.outputLineConsumer = outputLineConsumer;
    }

    public Consumer<String> getErrorLineConsumer() {
        return this.errorLineConsumer;
    }

    public void setErrorLineConsumer(Consumer<String> errorLineConsumer) {
        this.errorLineConsumer = errorLineConsumer;
    }

    public BiConsumer<Logger, String> getOutputLoggingConsumer() {
        return this.outputLoggingConsumer;
    }

    public void setOutputLoggingConsumer(BiConsumer<Logger, String> outputLoggingConsumer) {
        this.outputLoggingConsumer = outputLoggingConsumer;
    }

    public BiConsumer<Logger, String> getErrorLoggingConsumer() {
        return this.errorLoggingConsumer;
    }

    public void setErrorLoggingConsumer(BiConsumer<Logger, String> errorLoggingConsumer) {
        this.errorLoggingConsumer = errorLoggingConsumer;
    }

    public Consumer<ProcessBuilder> getProcessBuilderConsumer() {
        return this.processBuilderConsumer;
    }

    public void setProcessBuilderConsumer(Consumer<ProcessBuilder> processBuilderConsumer) {
        this.processBuilderConsumer = processBuilderConsumer;
    }

    public boolean isRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
    }

    public boolean isExceptionOnExitCode() {
        return this.exceptionOnExitCode;
    }

    public void setExceptionOnExitCode(boolean exceptionOnExitCode) {
        this.exceptionOnExitCode = exceptionOnExitCode;
    }

    public ProcessConfiguration clone() {
        try {
            ProcessConfiguration result = (ProcessConfiguration)super.clone();
            result.arguments = new ArrayList<String>(this.arguments);
            result.env = new LinkedHashMap<String, String>(this.env);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException(e);
        }
    }
}

