/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.util.Descriptive;
import org.openksavi.sponge.util.HasFeatures;
import org.openksavi.sponge.util.ProcessorPredicate;

public class CategoryMeta
implements Descriptive,
HasFeatures {
    private String name;
    private String label;
    private String description;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();
    private ProcessorPredicate predicate = processor -> false;

    private CategoryMeta() {
    }

    public CategoryMeta(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Map<String, Object> getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(Map<String, Object> features) {
        Validate.notNull(features, (String)"The category features cannot be null", (Object[])new Object[0]);
        this.features = new LinkedHashMap<String, Object>(features);
    }

    public ProcessorPredicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(ProcessorPredicate predicate) {
        this.predicate = predicate;
    }

    public CategoryMeta withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public CategoryMeta withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public CategoryMeta withFeatures(Map<String, Object> features) {
        this.getFeatures().putAll(features);
        return this;
    }

    public CategoryMeta withFeature(String name, Object value) {
        this.getFeatures().put(name, value);
        return this;
    }

    public CategoryMeta withPredicate(ProcessorPredicate predicate) {
        this.setPredicate(predicate);
        return this;
    }
}

