/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.type.provided;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openksavi.sponge.Experimental;
import org.openksavi.sponge.type.provided.ProvidedMode;
import org.openksavi.sponge.type.provided.SubmittableMeta;
import org.openksavi.sponge.type.provided.ValueSetMeta;

public class ProvidedMeta {
    private boolean value = false;
    private ValueSetMeta valueSet;
    private List<String> dependencies = new ArrayList<String>();
    private boolean overwrite = false;
    private boolean elementValueSet = false;
    private SubmittableMeta submittable;
    @Experimental
    private boolean lazyUpdate = false;
    private boolean current = false;
    private ProvidedMode mode = ProvidedMode.EXPLICIT;

    public ProvidedMeta withValue() {
        this.value = true;
        return this;
    }

    public ProvidedMeta withValueSet() {
        return this.withValueSet(new ValueSetMeta());
    }

    public ProvidedMeta withValueSet(ValueSetMeta valueSet) {
        this.valueSet = valueSet;
        return this;
    }

    public ProvidedMeta withDependencies(List<String> dependencies) {
        this.dependencies.addAll(dependencies);
        return this;
    }

    public ProvidedMeta withDependencies(String ... dependencies) {
        return this.withDependencies(Arrays.asList(dependencies));
    }

    public ProvidedMeta withDependency(String dependency) {
        return this.withDependencies(Arrays.asList(dependency));
    }

    public ProvidedMeta withOverwrite() {
        this.overwrite = true;
        return this;
    }

    public ProvidedMeta withElementValueSet() {
        this.elementValueSet = true;
        return this;
    }

    public ProvidedMeta withSubmittable(SubmittableMeta submittable) {
        this.submittable = submittable;
        return this;
    }

    public ProvidedMeta withSubmittable() {
        return this.withSubmittable(new SubmittableMeta());
    }

    public ProvidedMeta withLazyUpdate() {
        this.lazyUpdate = true;
        return this;
    }

    public ProvidedMeta withCurrent() {
        this.current = true;
        return this;
    }

    public ProvidedMeta withMode(ProvidedMode mode) {
        this.mode = mode;
        return this;
    }

    public ProvidedMeta withExplicitMode() {
        return this.withMode(ProvidedMode.EXPLICIT);
    }

    public ProvidedMeta withOptionalMode() {
        return this.withMode(ProvidedMode.OPTIONAL);
    }

    public ProvidedMeta withImplicitMode() {
        return this.withMode(ProvidedMode.IMPLICIT);
    }

    public boolean isValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public ValueSetMeta getValueSet() {
        return this.valueSet;
    }

    public void setValueSet(ValueSetMeta valueSet) {
        this.valueSet = valueSet;
    }

    public boolean hasValueSet() {
        return this.valueSet != null;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = new ArrayList<String>(dependencies);
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isElementValueSet() {
        return this.elementValueSet;
    }

    public void setElementValueSet(boolean elementValueSet) {
        this.elementValueSet = elementValueSet;
    }

    public SubmittableMeta getSubmittable() {
        return this.submittable;
    }

    public void setSubmittable(SubmittableMeta submittable) {
        this.submittable = submittable;
    }

    public boolean isLazyUpdate() {
        return this.lazyUpdate;
    }

    public void setLazyUpdate(boolean lazyUpdate) {
        this.lazyUpdate = lazyUpdate;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public ProvidedMode getMode() {
        return this.mode;
    }

    public void setMode(ProvidedMode mode) {
        this.mode = mode;
    }
}

