/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openksavi.sponge.type.TypeKind;

public class Type {
    private TypeKind kind;
    private String format;
    private List<String> tags = new ArrayList<String>();
    private Map<String, Object> features = new LinkedHashMap<String, Object>();

    private Type() {
    }

    protected Type(TypeKind kind) {
        this.kind = kind;
    }

    public Type format(String format) {
        this.setFormat(format);
        return this;
    }

    public Type tags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    public Type tag(String tag) {
        return this.tags(tag);
    }

    public Type features(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public Type feature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }

    public TypeKind getKind() {
        return this.kind;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = features;
    }
}

