/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.type;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openksavi.sponge.type.TypeKind;

public class Type<T> {
    private TypeKind kind;
    private String format;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();
    private T defaultValue;
    private boolean nullable = false;

    private Type() {
    }

    protected Type(TypeKind kind) {
        this();
        this.kind = kind;
    }

    public Type<T> format(String format) {
        this.setFormat(format);
        return this;
    }

    public Type<T> features(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public Type<T> feature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }

    public Type<T> defaultValue(T value) {
        this.setDefaultValue(value);
        return this;
    }

    public Type<T> nullable(boolean nullable) {
        this.setNullable(nullable);
        return this;
    }

    public TypeKind getKind() {
        return this.kind;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Map<String, Object> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = new LinkedHashMap<String, Object>(features);
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }
}

