/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openksavi.sponge.type.DataType;

public class ArgMeta<T extends DataType> {
    private String name;
    private T type;
    private String displayName;
    private String description;
    private boolean optional = false;
    private boolean provided = false;
    private List<String> depends = new ArrayList<String>();
    private boolean readOnly = false;
    private boolean overwrite = false;

    public ArgMeta(String name, T type) {
        this.name = name;
        this.type = type;
    }

    public ArgMeta<T> displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public ArgMeta<T> description(String description) {
        this.description = description;
        return this;
    }

    public ArgMeta<T> optional() {
        this.optional = true;
        return this;
    }

    public ArgMeta<T> provided() {
        this.provided = true;
        return this;
    }

    public ArgMeta<T> depends(String ... depends) {
        this.depends.addAll(Arrays.asList(depends));
        return this;
    }

    public ArgMeta<T> readOnly() {
        this.readOnly = true;
        return this;
    }

    public ArgMeta<T> overwrite() {
        this.overwrite = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T getType() {
        return this.type;
    }

    public void setType(T type) {
        this.type = type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getLabel() {
        return this.displayName != null ? this.displayName : this.name;
    }

    public boolean isProvided() {
        return this.provided;
    }

    public void setProvided(boolean provided) {
        this.provided = provided;
    }

    public List<String> getDepends() {
        return this.depends;
    }

    public void setDepends(List<String> depends) {
        this.depends = depends;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

