/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.util.process;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openksavi.sponge.util.process.ErrorRedirect;
import org.openksavi.sponge.util.process.InputRedirect;
import org.openksavi.sponge.util.process.OutputRedirect;
import org.openksavi.sponge.util.process.ProcessConfiguration;
import org.slf4j.Logger;

public class ProcessConfigurationBuilder {
    private ProcessConfiguration configuration;

    public ProcessConfigurationBuilder(String executable) {
        this.configuration = new ProcessConfiguration(executable);
    }

    public ProcessConfiguration build() {
        return this.configuration;
    }

    public ProcessConfigurationBuilder name(String name) {
        this.configuration.setName(name);
        return this;
    }

    public ProcessConfigurationBuilder arguments(String ... arguments) {
        this.arguments(Arrays.asList(arguments));
        return this;
    }

    public ProcessConfigurationBuilder arguments(List<String> arguments) {
        this.configuration.getArguments().addAll(arguments.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        return this;
    }

    public ProcessConfigurationBuilder workingDir(String workingDir) {
        this.configuration.setWorkingDir(workingDir);
        return this;
    }

    public ProcessConfigurationBuilder env(String name, String value) {
        this.configuration.getEnv().put(name, value);
        return this;
    }

    public ProcessConfigurationBuilder env(Map<String, String> env) {
        this.configuration.getEnv().putAll(env);
        return this;
    }

    public ProcessConfigurationBuilder waitSeconds(Long waitSeconds) {
        this.configuration.setWaitSeconds(waitSeconds);
        return this;
    }

    public ProcessConfigurationBuilder inputRedirect(InputRedirect inputRedirect) {
        this.configuration.setInputRedirect(inputRedirect);
        return this;
    }

    public ProcessConfigurationBuilder outputRedirect(OutputRedirect outputRedirect) {
        this.configuration.setOutputRedirect(outputRedirect);
        return this;
    }

    public ProcessConfigurationBuilder errorRedirect(ErrorRedirect errorRedirect) {
        this.configuration.setErrorRedirect(errorRedirect);
        return this;
    }

    public ProcessConfigurationBuilder charset(Charset charset) {
        this.configuration.setCharset(charset);
        return this;
    }

    public ProcessConfigurationBuilder waitForPositiveLineRegexp(String waitForPositiveLineRegexp) {
        this.configuration.setWaitForPositiveLineRegexp(waitForPositiveLineRegexp);
        return this;
    }

    public ProcessConfigurationBuilder waitForNegativeLineRegexp(String waitForNegativeLineRegexp) {
        this.configuration.setWaitForNegativeLineRegexp(waitForNegativeLineRegexp);
        return this;
    }

    public ProcessConfigurationBuilder waitForLineTimeout(Long waitForLineTimeout) {
        this.configuration.setWaitForLineTimeout(waitForLineTimeout);
        return this;
    }

    public ProcessConfigurationBuilder inputString(String inputString) {
        this.configuration.setInputString(inputString);
        return this;
    }

    public ProcessConfigurationBuilder inputBinary(byte[] inputBinary) {
        this.configuration.setInputBinary(inputBinary);
        return this;
    }

    public ProcessConfigurationBuilder inputFile(String inputFile) {
        this.configuration.setInputFile(inputFile);
        return this;
    }

    public ProcessConfigurationBuilder outputFile(String outputFile) {
        this.configuration.setOutputFile(outputFile);
        return this;
    }

    public ProcessConfigurationBuilder errorFile(String errorFile) {
        this.configuration.setErrorFile(errorFile);
        return this;
    }

    public ProcessConfigurationBuilder outputLineConsumer(Consumer<String> outputLineConsumer) {
        this.configuration.setOutputLineConsumer(outputLineConsumer);
        return this;
    }

    public ProcessConfigurationBuilder errorLineConsumer(Consumer<String> errorLineConsumer) {
        this.configuration.setErrorLineConsumer(errorLineConsumer);
        return this;
    }

    public ProcessConfigurationBuilder outputLoggingConsumer(BiConsumer<Logger, String> outputLoggingConsumer) {
        this.configuration.setOutputLoggingConsumer(outputLoggingConsumer);
        return this;
    }

    public ProcessConfigurationBuilder errorLoggingConsumer(BiConsumer<Logger, String> errorLoggingConsumer) {
        this.configuration.setErrorLoggingConsumer(errorLoggingConsumer);
        return this;
    }

    public ProcessConfigurationBuilder inheritIo() {
        return this.inputRedirect(InputRedirect.INHERIT).outputRedirect(OutputRedirect.INHERIT).errorRedirect(ErrorRedirect.INHERIT);
    }

    public ProcessConfigurationBuilder processBuilderConsumer(Consumer<ProcessBuilder> processBuilderConsumer) {
        this.configuration.setProcessBuilderConsumer(processBuilderConsumer);
        return this;
    }

    public ProcessConfigurationBuilder redirectErrorStream(boolean redirectErrorStream) {
        this.configuration.setRedirectErrorStream(redirectErrorStream);
        return this;
    }

    public ProcessConfigurationBuilder exceptionOnExitCode(boolean exceptionOnExitCode) {
        this.configuration.setExceptionOnExitCode(exceptionOnExitCode);
        return this;
    }

    public ProcessConfigurationBuilder inputAsInherit() {
        return this.inputRedirect(InputRedirect.INHERIT);
    }

    public ProcessConfigurationBuilder inputAsString(String inputString) {
        return this.inputRedirect(InputRedirect.STRING).inputString(inputString);
    }

    public ProcessConfigurationBuilder inputAsBinary(byte[] inputBinary) {
        return this.inputRedirect(InputRedirect.BINARY).inputBinary(inputBinary);
    }

    public ProcessConfigurationBuilder inputAsFile(String inputFile) {
        return this.inputRedirect(InputRedirect.FILE).inputFile(inputFile);
    }

    public ProcessConfigurationBuilder inputAsStream() {
        return this.inputRedirect(InputRedirect.STREAM);
    }

    public ProcessConfigurationBuilder outputAsInherit() {
        return this.outputRedirect(OutputRedirect.INHERIT);
    }

    public ProcessConfigurationBuilder outputAsString() {
        return this.outputRedirect(OutputRedirect.STRING);
    }

    public ProcessConfigurationBuilder outputAsBinary() {
        return this.outputRedirect(OutputRedirect.BINARY);
    }

    public ProcessConfigurationBuilder outputAsFile(String outputFile) {
        return this.outputRedirect(OutputRedirect.FILE).outputFile(outputFile);
    }

    public ProcessConfigurationBuilder outputAsConsumer(Consumer<String> outputLineConsumer) {
        return this.outputRedirect(OutputRedirect.CONSUMER).outputLineConsumer(outputLineConsumer);
    }

    public ProcessConfigurationBuilder outputAsConsumer() {
        return this.outputRedirect(OutputRedirect.CONSUMER);
    }

    public ProcessConfigurationBuilder errorAsInherit() {
        return this.errorRedirect(ErrorRedirect.INHERIT);
    }

    public ProcessConfigurationBuilder errorAsString() {
        return this.errorRedirect(ErrorRedirect.STRING);
    }

    public ProcessConfigurationBuilder errorAsFile(String errorFile) {
        return this.errorRedirect(ErrorRedirect.FILE).errorFile(errorFile);
    }

    public ProcessConfigurationBuilder errorAsException() {
        return this.errorRedirect(ErrorRedirect.EXCEPTION);
    }

    public ProcessConfigurationBuilder errorAsConsumer() {
        return this.errorRedirect(ErrorRedirect.CONSUMER);
    }
}

