/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.type;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openksavi.sponge.type.DataTypeKind;

public class DataType<T> {
    private DataTypeKind kind;
    private String format;
    private T defaultValue;
    private boolean nullable = false;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();

    private DataType() {
    }

    protected DataType(DataTypeKind kind) {
        this();
        this.kind = kind;
    }

    public DataType<T> format(String format) {
        this.setFormat(format);
        return this;
    }

    public DataType<T> defaultValue(T value) {
        this.setDefaultValue(value);
        return this;
    }

    public DataType<T> nullable(boolean nullable) {
        this.setNullable(nullable);
        return this;
    }

    public DataType<T> nullable() {
        return this.nullable(true);
    }

    public DataType<T> features(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public DataType<T> feature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }

    public DataTypeKind getKind() {
        return this.kind;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public Map<String, Object> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = new LinkedHashMap<String, Object>(features);
    }
}

