/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.util;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.action.ActionMeta;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.QualifiedDataType;
import org.openksavi.sponge.type.RecordType;
import org.openksavi.sponge.util.ValueHolder;

public abstract class SpongeApiUtils {
    private SpongeApiUtils() {
    }

    public static int getActionArgIndex(List<DataType> argTypes, String argName) {
        if (argTypes != null) {
            for (int i = 0; i < argTypes.size(); ++i) {
                if (!argTypes.get(i).getName().equals(argName)) continue;
                return i;
            }
        }
        return -1;
    }

    public static DataType getActionArgType(List<DataType> argTypes, String argName) {
        Validate.notNull(argTypes, (String)"Arguments not defined", (Object[])new Object[0]);
        List<String> elements = SpongeApiUtils.getActionArgNameElements(argName);
        ValueHolder<DataType> argTypeHolder = new ValueHolder<DataType>(argTypes.get(SpongeApiUtils.getActionArgIndex(argTypes, elements.get(0))));
        elements.stream().skip(1L).limit(elements.size() - 1).forEach(element -> {
            DataType argType = (DataType)argTypeHolder.getValue();
            Validate.notNull(argTypeHolder.getValue(), (String)"Argument '%s' not found", (Object[])new Object[]{argName});
            Validate.notNull((Object)argType.getName(), (String)"The sub-type nas no name", (Object[])new Object[0]);
            Validate.isTrue((boolean)(argType instanceof RecordType), (String)"The element %s is not a record", (Object[])new Object[]{argType.getName()});
            argTypeHolder.setValue(((RecordType)argType).getFields().stream().filter(fieldType -> fieldType.getName().equals(element)).findFirst().orElse(null));
        });
        return argTypeHolder.getValue();
    }

    public static Map<String, DataType> createNamedActionArgTypesMap(ActionMeta actionMeta) {
        LinkedHashMap<String, DataType> argTypesMap = new LinkedHashMap<String, DataType>();
        SpongeApiUtils.traverseActionArguments(actionMeta, qType -> argTypesMap.put(qType.getPath(), qType.getType()), true);
        return argTypesMap;
    }

    public static List<String> getActionArgNameElements(String name) {
        return Arrays.asList(name.split("\\."));
    }

    public static void traverseActionArguments(ActionMeta actionMeta, Consumer<QualifiedDataType> onType, boolean namedOnly) {
        if (actionMeta.getArgs() != null) {
            actionMeta.getArgs().forEach(argType -> SpongeApiUtils.traverseDataType(new QualifiedDataType(argType.getName(), argType), onType, namedOnly));
        }
    }

    public static void traverseDataType(QualifiedDataType qType, Consumer<QualifiedDataType> onType, boolean namedOnly) {
        if (namedOnly && qType.getType().getName() == null) {
            return;
        }
        onType.accept(qType);
        switch (qType.getType().getKind()) {
            case RECORD: {
                ((RecordType)qType.getType()).getFields().forEach(field -> SpongeApiUtils.traverseDataType(qType.createChild(field), onType, namedOnly));
                break;
            }
        }
    }
}

