/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.DataTypeKind;
import org.openksavi.sponge.type.provided.ProvidedMeta;

public class RecordType
extends DataType<Map<String, Object>> {
    private List<DataType> fields;

    public RecordType() {
        this((String)null);
    }

    public RecordType(String name) {
        this(name, new ArrayList<DataType>());
    }

    public RecordType(List<DataType> fields) {
        this(null, fields);
    }

    public RecordType(String name, List<DataType> fields) {
        super(DataTypeKind.RECORD, name);
        this.fields = new ArrayList<DataType>(fields);
    }

    public RecordType withName(String name) {
        return (RecordType)super.withName(name);
    }

    public RecordType withLabel(String label) {
        return (RecordType)super.withLabel(label);
    }

    public RecordType withDescription(String description) {
        return (RecordType)super.withDescription(description);
    }

    public RecordType withAnnotated(boolean annotated) {
        return (RecordType)super.withAnnotated(annotated);
    }

    public RecordType withAnnotated() {
        return (RecordType)super.withAnnotated();
    }

    public RecordType withFormat(String format) {
        return (RecordType)super.withFormat(format);
    }

    public RecordType withFeatures(Map<String, Object> features) {
        return (RecordType)super.withFeatures(features);
    }

    public RecordType withFeature(String name, Object value) {
        return (RecordType)super.withFeature(name, value);
    }

    public RecordType withDefaultValue(Map<String, Object> value) {
        return (RecordType)super.withDefaultValue(value);
    }

    public RecordType withNullable(boolean nullable) {
        return (RecordType)super.withNullable(nullable);
    }

    public RecordType withNullable() {
        return (RecordType)super.withNullable();
    }

    public RecordType withOptional() {
        return (RecordType)super.withOptional();
    }

    public RecordType withProvided(ProvidedMeta provided) {
        return (RecordType)super.withProvided(provided);
    }

    public RecordType withFields(List<DataType> fields) {
        fields.forEach(field -> {
            boolean replaced = false;
            for (int i = 0; i < this.fields.size(); ++i) {
                if (!Objects.equals(field.getName(), this.fields.get(i).getName())) continue;
                this.fields.set(i, (DataType)field);
                replaced = true;
            }
            if (!replaced) {
                this.fields.add((DataType)field);
            }
        });
        return this;
    }

    public List<DataType> getFields() {
        return this.fields;
    }

    public void setFields(List<DataType> fields) {
        this.fields = new ArrayList<DataType>(fields);
    }

    @Override
    public RecordType clone() {
        RecordType cloned = (RecordType)super.clone();
        cloned.fields = this.fields != null ? new ArrayList(this.fields.stream().map(field -> field != null ? field.clone() : null).collect(Collectors.toList())) : null;
        return cloned;
    }
}

