/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.camel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.camel.CamelConsumer;
import org.openksavi.sponge.camel.SpongeCamelEvent;
import org.openksavi.sponge.core.util.Utils;
import org.openksavi.sponge.java.JavaPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelPlugin
extends JavaPlugin
implements CamelContextAware {
    private static final Logger logger = LoggerFactory.getLogger(CamelPlugin.class);
    public static final String NAME = "camel";
    public static final String PRODUCER_TEMPLATE = "spongeProducerTemplate";
    private CamelContext camelContext;
    private List<CamelConsumer> consumers = Collections.synchronizedList(new ArrayList());
    private volatile ProducerTemplate producerTemplate;
    private boolean producerTemplateCreatedManually = false;

    public CamelPlugin(CamelContext camelContext) {
        this.setName(NAME);
        this.setContext(camelContext);
    }

    public CamelPlugin() {
        this.setName(NAME);
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(CamelContext camelContext) {
        CamelPlugin camelPlugin = this;
        synchronized (camelPlugin) {
            if (this.camelContext != null && this.camelContext != camelContext) {
                throw new SpongeException("Camel plugin has already been initialized with a different Camel context");
            }
            this.camelContext = camelContext;
        }
    }

    public List<CamelConsumer> getConsumers() {
        return this.consumers;
    }

    public void addConsumer(CamelConsumer consumer) {
        logger.debug("Adding consumer {}", (Object)consumer);
        this.consumers.add(consumer);
    }

    public boolean removeConsumer(CamelConsumer consumer) {
        logger.debug("Removing consumer {}", (Object)consumer);
        return this.consumers.remove(consumer);
    }

    public SpongeCamelEvent makeInputEvent(String name, Exchange exchange) {
        return SpongeCamelEvent.create(this.getEngine(), name, exchange);
    }

    public void send(Object body) {
        if (this.consumers.isEmpty()) {
            logger.debug("No consumer to send a message");
        }
        this.consumers.forEach(consumer -> {
            logger.debug("Sending to consumer {}", consumer);
            consumer.send(body);
        });
    }

    public void send(String uri, Object body) {
        this.getProducerTemplate().sendBody(uri, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerTemplate getProducerTemplate() {
        ProducerTemplate result = this.producerTemplate;
        if (result == null) {
            CamelPlugin camelPlugin = this;
            synchronized (camelPlugin) {
                result = this.producerTemplate;
                if (result == null) {
                    result = (ProducerTemplate)this.camelContext.getRegistry().lookupByNameAndType(PRODUCER_TEMPLATE, ProducerTemplate.class);
                }
                if (result == null) {
                    result = this.camelContext.createProducerTemplate();
                    this.producerTemplateCreatedManually = true;
                }
                this.producerTemplate = result;
            }
        }
        return result;
    }

    public Object request(String uri, Object body) {
        return this.getProducerTemplate().requestBody(uri, body);
    }

    public String getRouteId(Exchange exchange) {
        return exchange.getUnitOfWork().getRouteContext().getRoute().getId();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void onShutdown() {
        if (this.producerTemplateCreatedManually && this.producerTemplate != null) {
            try {
                this.producerTemplate.stop();
            }
            catch (Exception e) {
                throw Utils.wrapException((String)((Object)((Object)this)).getClass().getSimpleName(), (Throwable)e);
            }
        }
    }
}

