/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.camel;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.openksavi.sponge.core.event.BaseEvent;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.event.EventClonePolicy;

public class SpongeCamelEvent
extends BaseEvent {
    private static final long serialVersionUID = -4656303834851564743L;
    public static final String ATTR_ROUTE_ID = "routeId";
    public static final String ATTR_BODY = "body";
    public static final String ATTR_HEADERS = "headers";
    private final String routeId;
    private Object body;
    private Map<String, Object> headers;

    public SpongeCamelEvent(String name, EventClonePolicy clonePolicy, String routeId, Object body, Map<String, Object> headers) {
        super(name, clonePolicy);
        this.routeId = routeId;
        this.body = body;
        this.headers = headers;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public Object get(String name) {
        switch (name) {
            case "routeId": {
                return this.routeId;
            }
            case "body": {
                return this.body;
            }
            case "headers": {
                return this.headers;
            }
        }
        throw new IllegalArgumentException("Unknown attribute " + name);
    }

    public SpongeCamelEvent set(String name, Object value) {
        switch (name) {
            case "routeId": {
                if (Objects.equals(this.routeId, value)) break;
                throw new IllegalArgumentException("Attribute " + name + " can't be changed");
            }
            case "body": {
                this.body = value;
                break;
            }
            case "headers": {
                this.headers = (Map)value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown attribute " + name);
            }
        }
        return this;
    }

    public boolean has(String name) {
        return ATTR_ROUTE_ID.equals(name) || ATTR_BODY.equals(name) || ATTR_HEADERS.equals(name);
    }

    public Map<String, Object> getAll() {
        return ImmutableMap.of((Object)ATTR_ROUTE_ID, (Object)this.routeId, (Object)ATTR_BODY, (Object)this.body, (Object)ATTR_HEADERS, this.headers);
    }

    public static SpongeCamelEvent create(Engine engine, String name, Exchange exchange) {
        return new SpongeCamelEvent(name, engine.getConfigurationManager().getEventClonePolicy(), exchange.getUnitOfWork().getRouteContext().getRoute().getId(), exchange.getIn().getBody(), exchange.getIn().getHeaders());
    }

    public static SpongeCamelEvent create(Engine engine, Exchange exchange) {
        String exchangRouteId = exchange.getUnitOfWork().getRouteContext().getRoute().getId();
        return new SpongeCamelEvent(exchangRouteId, engine.getConfigurationManager().getEventClonePolicy(), exchangRouteId, exchange.getIn().getBody(), exchange.getIn().getHeaders());
    }
}

