/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.camel;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.openksavi.sponge.engine.Engine;

public class SpongeProducer
extends DefaultProducer {
    private final Engine engine;
    private final String action;

    public SpongeProducer(Endpoint endpoint, Engine engine, String action) {
        super(endpoint);
        this.engine = engine;
        this.action = action;
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String actionName = (String)in.getHeader("CamelSpongeAction", String.class);
        if (actionName != null) {
            in.removeHeader("CamelSpongeAction");
        }
        if (actionName == null) {
            actionName = this.action != null ? this.action : "CamelProducerAction";
        }
        Object result = this.engine.getOperations().call(actionName, new Object[]{exchange});
        exchange.getIn().setBody(result);
    }
}

