/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.camel;

import java.util.Arrays;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.DefaultProducer;
import org.openksavi.sponge.engine.SpongeEngine;

public class SpongeProducer
extends DefaultProducer {
    private final SpongeEngine engine;
    private final String action;

    public SpongeProducer(Endpoint endpoint, SpongeEngine engine, String action) {
        super(endpoint);
        this.engine = engine;
        this.action = action;
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String actionName = (String)in.getHeader("CamelSpongeAction", String.class);
        if (actionName != null) {
            in.removeHeader("CamelSpongeAction");
        }
        if (actionName == null) {
            actionName = this.action != null ? this.action : "CamelProducerAction";
        }
        exchange.getIn().setBody(this.engine.getOperations().call(actionName, Arrays.asList(exchange)));
    }
}

