/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.camel;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedStartupListener;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.camel.CamelConsumer;
import org.openksavi.sponge.camel.CamelProcessorProvider;
import org.openksavi.sponge.camel.SpongeCamelEvent;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.java.JPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeferredContextBinding
public class CamelPlugin
extends JPlugin
implements CamelContextAware,
ExtendedStartupListener {
    private static final Logger logger = LoggerFactory.getLogger(CamelPlugin.class);
    public static final String NAME = "camel";
    public static final String PRODUCER_TEMPLATE = "spongeProducerTemplate";
    private CamelContext camelContext;
    private List<CamelConsumer> consumers = new CopyOnWriteArrayList<CamelConsumer>();
    private volatile ProducerTemplate producerTemplate;
    private boolean producerTemplateCreatedManually = false;
    private boolean waitForContextFullyStarted = false;
    private AtomicBoolean contextFullyStarted = new AtomicBoolean(false);
    private final CountDownLatch contextFullyStartedLatch = new CountDownLatch(1);
    private Lock lock = new ReentrantLock(true);

    public CamelPlugin(CamelContext camelContext) {
        this();
        this.setContext(camelContext);
    }

    public CamelPlugin() {
        super(NAME);
    }

    public CamelPlugin(String name) {
        super(name);
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public void waitForContextFullyStarted() {
        if (this.waitForContextFullyStarted && !this.contextFullyStarted.get()) {
            try {
                this.contextFullyStartedLatch.await();
                this.contextFullyStarted.set(true);
            }
            catch (InterruptedException e) {
                throw SpongeUtils.wrapException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(CamelContext camelContext) {
        CamelPlugin camelPlugin = this;
        synchronized (camelPlugin) {
            if (this.camelContext != null && this.camelContext != camelContext) {
                throw new SpongeException("Camel plugin has already been initialized with a different Camel context");
            }
            this.camelContext = camelContext;
        }
    }

    public List<CamelConsumer> getConsumers() {
        return this.consumers;
    }

    public void addConsumer(CamelConsumer consumer) {
        logger.debug("Adding consumer {}", (Object)consumer);
        this.consumers.add(consumer);
    }

    public boolean removeConsumer(CamelConsumer consumer) {
        logger.debug("Removing consumer {}", (Object)consumer);
        return this.consumers.remove(consumer);
    }

    public SpongeCamelEvent makeInputEvent(String name, Exchange exchange) {
        return SpongeCamelEvent.create(this.getEngine(), name, exchange);
    }

    public void emit(Object body) {
        if (this.consumers.isEmpty()) {
            logger.debug("No consumer to emit a message");
        } else {
            this.waitForContextFullyStarted();
            this.consumers.forEach(consumer -> {
                logger.debug("Emitting to consumer {}", consumer);
                consumer.emit(body);
            });
        }
    }

    public void sendBody(String uri, Object body) {
        this.getProducerTemplate().sendBody(uri, body);
    }

    public Object requestBody(String uri, Object body) {
        return this.getProducerTemplate().requestBody(uri, body);
    }

    public ProducerTemplate getProducerTemplate() {
        ProducerTemplate result = this.producerTemplate;
        if (result == null) {
            this.lock.lock();
            try {
                result = this.producerTemplate;
                if (result == null) {
                    result = (ProducerTemplate)this.camelContext.getRegistry().lookupByNameAndType(PRODUCER_TEMPLATE, ProducerTemplate.class);
                }
                if (result == null) {
                    result = this.camelContext.createProducerTemplate();
                    this.producerTemplateCreatedManually = true;
                }
                this.waitForContextFullyStarted();
                this.producerTemplate = result;
            }
            finally {
                this.lock.unlock();
            }
        }
        return result;
    }

    public void addAttachment(Exchange exchange, String attachmentFile) {
        ((AttachmentMessage)Validate.notNull((Object)exchange.getMessage(AttachmentMessage.class), (String)"The message doesn't support attachments", (Object[])new Object[0])).addAttachment(FilenameUtils.getName((String)attachmentFile), new DataHandler((DataSource)new FileDataSource(attachmentFile)));
    }

    public String getRouteId(Exchange exchange) {
        return exchange.getUnitOfWork().getRouteContext().getRoute().getId();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public boolean isWaitForContextFullyStarted() {
        return this.waitForContextFullyStarted;
    }

    public void setWaitForContextFullyStarted(boolean waitForContextFullyStarted) {
        this.waitForContextFullyStarted = waitForContextFullyStarted;
    }

    public void onShutdown() {
        if (this.producerTemplateCreatedManually && this.producerTemplate != null) {
            try {
                this.producerTemplate.stop();
            }
            catch (Exception e) {
                throw SpongeUtils.wrapException((Throwable)e);
            }
        }
    }

    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
    }

    public void onCamelContextFullyStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        this.contextFullyStartedLatch.countDown();
    }

    public Processor processor(CamelProcessorProvider provider) {
        return exchange -> provider.process(exchange);
    }
}

