/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.camel.CamelPlugin;
import org.openksavi.sponge.camel.CamelProducerAction;
import org.openksavi.sponge.camel.SpongeConsumer;
import org.openksavi.sponge.camel.SpongeProducer;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.plugin.Plugin;

@UriEndpoint(scheme="sponge", title="Sponge", syntax="sponge:engineRef", consumerClass=SpongeConsumer.class, label="sponge")
public class SpongeEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    public static final Boolean DEFAULT_MANAGED = true;
    private SpongeEngine engine;
    @UriPath
    private String engineRef;
    @UriParam
    private String action;
    @UriParam
    private Boolean managed;
    private boolean autoStarted = false;

    public SpongeEndpoint(String endpointUri, Component component, SpongeEngine engine, String action, Boolean managed) {
        super(endpointUri, component);
        this.engine = engine;
        this.action = action;
        this.managed = managed != null ? managed : DEFAULT_MANAGED;
    }

    public Producer createProducer() throws Exception {
        return new SpongeProducer((Endpoint)this, this.engine, this.action);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SpongeConsumer answer = new SpongeConsumer(this, processor, this.engine);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public Exchange createExchange(Object body) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody(body);
        return exchange;
    }

    public String getEngineRef() {
        return this.engineRef;
    }

    public void setEngineRef(String engineRef) {
        this.engineRef = engineRef;
    }

    public SpongeEngine getEngine() {
        return this.engine;
    }

    public void setEngine(SpongeEngine engine) {
        this.engine = engine;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Boolean getManaged() {
        return this.managed;
    }

    public void setManaged(Boolean managed) {
        this.managed = managed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        super.doStart();
        if (this.engineRef != null && this.engine == null) {
            this.engine = (SpongeEngine)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.engineRef, SpongeEngine.class);
        }
        Component component = this.getComponent();
        synchronized (component) {
            this.configurePlugin();
            if (this.managed != null && this.managed.booleanValue() && !this.engine.isStarting() && !this.engine.isRunning()) {
                this.engine.startup();
                this.autoStarted = true;
            }
            if (!this.engine.isStarting() && !this.engine.isRunning()) {
                throw new SpongeException("Sponge engine is not starting or running");
            }
            this.configureAction();
        }
    }

    protected void configurePlugin() {
        if (this.engine.getOperations().hasPlugin(CamelPlugin.class, "camel")) {
            ((CamelPlugin)this.engine.getOperations().getPlugin(CamelPlugin.class, "camel")).setContext(this.getCamelContext());
        } else {
            this.engine.getPluginManager().addPlugin((Plugin)new CamelPlugin(this.getCamelContext()));
        }
    }

    protected void configureAction() {
        if (!this.engine.getOperations().hasAction("CamelProducerAction")) {
            this.engine.getOperations().enableJava(CamelProducerAction.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Component component = this.getComponent();
        synchronized (component) {
            if (this.managed != null && this.managed.booleanValue() && this.autoStarted && this.engine.isRunning()) {
                this.engine.shutdown();
            }
        }
        super.doStop();
    }
}

