/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.camel;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.util.ObjectHelper;
import org.openksavi.sponge.camel.CamelConsumer;
import org.openksavi.sponge.camel.SpongeEndpoint;

public class DefaultCamelConsumer
implements CamelConsumer {
    protected final SpongeEndpoint spongeEndpoint;
    protected final AsyncProcessor processor;

    public DefaultCamelConsumer(SpongeEndpoint spongeEndpoint, Processor processor) {
        ObjectHelper.notNull((Object)((Object)spongeEndpoint), (String)"spongeEndpoint");
        ObjectHelper.notNull((Object)processor, (String)"processor");
        this.spongeEndpoint = spongeEndpoint;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
    }

    @Override
    public boolean emit(Object body) {
        return this.emit(this.spongeEndpoint.createExchange(body));
    }

    @Override
    public boolean emit(Exchange exchange) {
        return this.emit(exchange, callback -> {});
    }

    @Override
    public boolean emit(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    @Override
    public Endpoint getEndpoint() {
        return this.spongeEndpoint;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    public String toString() {
        return this.spongeEndpoint != null ? this.spongeEndpoint.toString() : super.toString();
    }
}

