/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.camel;

import org.apache.camel.Exchange;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.util.jsse.KeyManagersParameters;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.camel.util.jsse.TrustManagersParameters;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.camel.CamelPlugin;
import org.openksavi.sponge.camel.SpongeCamelEvent;
import org.openksavi.sponge.core.util.SslConfiguration;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventDefinition;

public abstract class CamelUtils {
    public static void assertCamelProducerActionArgs(Action action, Object ... args) {
        if (args == null || args.length != 1 || !(args[0] instanceof Exchange)) {
            throw new IllegalArgumentException(action.getName() + " requires exactly one argument of class " + Exchange.class);
        }
    }

    public static Event getEvent(Exchange exchange) {
        Object body;
        if (exchange.getIn() != null && (body = exchange.getIn().getBody()) != null) {
            if (body instanceof Event) {
                return (Event)body;
            }
            if (body instanceof EventDefinition) {
                return ((EventDefinition)body).make();
            }
        }
        return null;
    }

    public static Event getOrCreateInputEvent(SpongeEngine engine, Exchange exchange) {
        Object event = CamelUtils.getEvent(exchange);
        if (event == null) {
            event = SpongeCamelEvent.create(engine, exchange);
        }
        return event;
    }

    public static String xpath(Exchange exchange, String path) {
        return (String)XPathBuilder.xpath((String)path).stringResult().evaluate(exchange, String.class);
    }

    public static CamelPlugin getPlugin(SpongeEngine engine) {
        CamelPlugin plugin = (CamelPlugin)engine.getPluginManager().getPlugin("camel", CamelPlugin.class);
        if (plugin == null) {
            throw new SpongeException("Camel plugin not found");
        }
        return plugin;
    }

    public static SSLContextParameters createSslContextParameters(SslConfiguration security) {
        KeyStoreParameters keyStoreParameters = new KeyStoreParameters();
        keyStoreParameters.setResource(security.getKeyStore());
        keyStoreParameters.setPassword(security.getKeyStorePassword());
        KeyManagersParameters keyManagersParameters = new KeyManagersParameters();
        keyManagersParameters.setKeyStore(keyStoreParameters);
        keyManagersParameters.setKeyPassword(security.getKeyPassword());
        TrustManagersParameters trustManagersParameters = new TrustManagersParameters();
        trustManagersParameters.setKeyStore(keyStoreParameters);
        SSLContextParameters sslContextParameters = new SSLContextParameters();
        sslContextParameters.setKeyManagers(keyManagersParameters);
        sslContextParameters.setTrustManagers(trustManagersParameters);
        return sslContextParameters;
    }
}

