/*
 * Copyright 2016-2017 The Sponge authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.openksavi.sponge.core.engine;

/**
 * Plugin manager constants.
 */
public final class PluginManagerConstants {

    /** Plugins tag. */
    public static final String CFG_PLUGINS = "plugins";

    /** Plugin tag. */
    public static final String CFG_PLUGIN = "plugin";

    /** Plugin name tag. */
    public static final String CFG_PLUGIN_NAME = "name";

    /** Plugin class tag. */
    public static final String CFG_PLUGIN_CLASS = "class";

    /** Plugin knowledge base name. */
    public static final String CFG_PLUGIN_KB_NAME = "knowledgeBaseName";

    /** Plugin configuration tag. */
    public static final String CFG_PLUGIN_CONFIGURATION = "configuration";

    private PluginManagerConstants() {
        //
    }
}
