/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.util.function.Supplier;
import org.openksavi.sponge.EngineOperations;
import org.openksavi.sponge.core.engine.BaseEngine;
import org.openksavi.sponge.core.event.AttributeMapEvent;
import org.openksavi.sponge.core.event.DefaultEventDefinition;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventClonePolicy;
import org.openksavi.sponge.event.EventDefinition;
import org.openksavi.sponge.event.EventSchedulerEntry;
import org.openksavi.sponge.plugin.Plugin;

public class BaseEngineOperations
implements EngineOperations {
    protected BaseEngine engine;

    public BaseEngineOperations(BaseEngine engine) {
        this.engine = engine;
    }

    public BaseEngine getEngine() {
        return this.engine;
    }

    public Object call(String actionName, Object ... args) {
        return this.engine.getActionManager().callAction(actionName, args);
    }

    public Event send(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        this.engine.getEventScheduler().scheduleNow(event);
        return event;
    }

    public Event send(String eventName) {
        return this.send(this.makeEvent(eventName));
    }

    public EventSchedulerEntry sendAfter(String name, long delay) {
        return this.sendAfter(this.makeEvent(name), delay, 0L);
    }

    public EventSchedulerEntry sendAfter(String name, long delay, long interval) {
        return this.sendAfter(this.makeEvent(name), delay, interval);
    }

    public EventSchedulerEntry sendAfter(Event event, long delay) {
        return this.sendAfter(event, delay, 0L);
    }

    public EventSchedulerEntry sendAfter(Event event, long delay, long interval) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        return this.engine.getEventScheduler().scheduleAfter(event, delay, interval);
    }

    public EventSchedulerEntry sendAt(String name, long milliseconds) {
        return this.sendAt(this.makeEvent(name), milliseconds, 0L);
    }

    public EventSchedulerEntry sendAt(String name, long milliseconds, long interval) {
        return this.sendAt(this.makeEvent(name), milliseconds, interval);
    }

    public EventSchedulerEntry sendAt(Event event, long milliseconds) {
        return this.sendAt(event, milliseconds, 0L);
    }

    public EventSchedulerEntry sendAt(Event event, long milliseconds, long interval) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        return this.engine.getEventScheduler().scheduleAt(event, milliseconds, interval);
    }

    public EventSchedulerEntry sendAt(Event event, String crontabSpec) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        if (crontabSpec == null) {
            throw new IllegalArgumentException("Crontab specification cannot be null");
        }
        return this.engine.getEventScheduler().scheduleAt(event, crontabSpec);
    }

    public EventSchedulerEntry sendAt(String name, String crontabSpec) {
        return this.sendAt(this.makeEvent(name), crontabSpec);
    }

    public boolean removeEvent(EventSchedulerEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Event entry cannot be null");
        }
        return this.engine.getEventScheduler().remove(entry);
    }

    public Plugin getPlugin(String name) {
        return this.engine.getPluginManager().getPlugin(name);
    }

    public <T extends Plugin> T getPlugin(String name, Class<T> cls) {
        return (T)this.engine.getPluginManager().getPlugin(name, cls);
    }

    public <T extends Plugin> T getPlugin(Class<T> cls) {
        return (T)this.engine.getPluginManager().getPlugin(cls);
    }

    public String getVersion() {
        return this.engine.getVersion();
    }

    public String getDescription() {
        return this.engine.getDescription();
    }

    public String getStatisticsSummary() {
        return this.engine.getStatisticsManager().getSummary();
    }

    public Event makeEvent(String name) {
        return new AttributeMapEvent(name, this.engine.getConfigurationManager().getEventClonePolicy());
    }

    public Event makeEvent(String name, EventClonePolicy policy) {
        return new AttributeMapEvent(name, policy);
    }

    public EventDefinition event(String name) {
        return new DefaultEventDefinition(this, name, this.engine.getConfigurationManager().getEventClonePolicy());
    }

    public EventDefinition event(String name, EventClonePolicy policy) {
        return new DefaultEventDefinition(this, name, policy);
    }

    public EventDefinition event(Event event) {
        return new DefaultEventDefinition(this, event);
    }

    public void shutdown() {
        this.engine.shutdown();
    }

    public void requestShutdown() {
        this.engine.requestShutdown();
    }

    public void reload() {
        this.engine.reload();
    }

    public void requestReload() {
        this.engine.requestReload();
    }

    public boolean existsAction(String name) {
        return this.engine.getActionManager().existsAction(name);
    }

    public boolean existsFilter(String name) {
        return this.engine.getFilterProcessingUnit().existsProcessor(name);
    }

    public boolean existsTrigger(String name) {
        return this.engine.getMainProcessingUnit().existsProcessor(name);
    }

    public boolean existsRule(String name) {
        return this.engine.getMainProcessingUnit().existsProcessor(name);
    }

    public boolean existsCorrelator(String name) {
        return this.engine.getMainProcessingUnit().existsProcessor(name);
    }

    public void setVariable(String name, Object value) {
        this.engine.getSession().setVariable(name, value);
    }

    public Object getVariable(String name) {
        return this.engine.getSession().getVariable(name);
    }

    public <T> T getVariable(Class<T> cls, String name) {
        return (T)this.engine.getSession().getVariable(cls, name);
    }

    public <T> T getVariable(String name, T defaultValue) {
        return (T)this.engine.getSession().getVariable(name, defaultValue);
    }

    public <T> T getVariable(Class<T> cls, String name, T defaultValue) {
        return (T)this.engine.getSession().getVariable(cls, name, defaultValue);
    }

    public boolean existsVariable(String name) {
        return this.engine.getSession().existsVariable(name);
    }

    public void removeVariable(String name) {
        this.engine.getSession().removeVariable(name);
    }

    public <T> void setVariableIfNone(String name, Supplier<T> supplier) {
        this.engine.getSession().setVariableIfNone(name, supplier);
    }

    public void updateVariable(String name) {
        this.engine.getSession().updateVariable(name);
    }
}

