/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class VersionInfo {
    public static final String PRODUCT = "Sponge";
    private static final String VERSION_PROPERTY = "version";
    private static final String VERSION_PROPERTIES = "/org/openksavi/sponge/version.properties";
    private String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        if (this.version == null) {
            VersionInfo versionInfo = this;
            synchronized (versionInfo) {
                this.version = this.readVersion();
            }
        }
        return this.version;
    }

    private String readVersion() {
        Properties properties = new Properties();
        try (InputStream stream = this.getClass().getResourceAsStream(VERSION_PROPERTIES);){
            properties.load(stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties.getProperty(VERSION_PROPERTY);
    }

    public String getDescription() {
        return "Sponge " + this.getVersion();
    }

    public String getDescription(String engineName) {
        return PRODUCT + (engineName != null ? "(" + engineName + ")" : "") + " " + this.getVersion();
    }

    public String getProduct() {
        return PRODUCT;
    }
}

