/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.core.VersionInfo;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.engine.DefaultEngineParameters;
import org.openksavi.sponge.core.engine.DefaultSession;
import org.openksavi.sponge.core.engine.GenericExceptionContext;
import org.openksavi.sponge.core.engine.LoggingExceptionHandler;
import org.openksavi.sponge.core.engine.processing.QueuedEventSetProcessorDurationStrategy;
import org.openksavi.sponge.core.kb.BaseKnowledgeBaseEngineOperations;
import org.openksavi.sponge.core.kb.DefaultKnowledgeBaseFileProvider;
import org.openksavi.sponge.core.spi.DefaultEngineModuleProvider;
import org.openksavi.sponge.core.spi.DefaultEventQueueProvider;
import org.openksavi.sponge.core.spi.DefaultProcessingUnitProvider;
import org.openksavi.sponge.core.util.RegexPatternMatcher;
import org.openksavi.sponge.core.util.ServiceLoaderUtils;
import org.openksavi.sponge.core.util.Utils;
import org.openksavi.sponge.correlator.CorrelatorAdapterGroup;
import org.openksavi.sponge.engine.ActionManager;
import org.openksavi.sponge.engine.ConfigurationManager;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.engine.EngineModule;
import org.openksavi.sponge.engine.EngineParameters;
import org.openksavi.sponge.engine.EventQueueManager;
import org.openksavi.sponge.engine.ExceptionContext;
import org.openksavi.sponge.engine.ExceptionHandler;
import org.openksavi.sponge.engine.KnowledgeBaseManager;
import org.openksavi.sponge.engine.OnShutdownListener;
import org.openksavi.sponge.engine.OnStartupListener;
import org.openksavi.sponge.engine.PluginManager;
import org.openksavi.sponge.engine.ProcessingUnitManager;
import org.openksavi.sponge.engine.ProcessorManager;
import org.openksavi.sponge.engine.Session;
import org.openksavi.sponge.engine.StatisticsManager;
import org.openksavi.sponge.engine.ThreadPoolManager;
import org.openksavi.sponge.engine.event.EventQueue;
import org.openksavi.sponge.engine.event.EventScheduler;
import org.openksavi.sponge.engine.processing.EventSetProcessorDurationStrategy;
import org.openksavi.sponge.engine.processing.MainProcessingUnit;
import org.openksavi.sponge.engine.processing.ProcessingUnit;
import org.openksavi.sponge.filter.FilterAdapter;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseFileProvider;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.rule.RuleAdapterGroup;
import org.openksavi.sponge.spi.EngineModuleProvider;
import org.openksavi.sponge.spi.EventQueueProvider;
import org.openksavi.sponge.spi.KnowledgeBaseInterpreterFactoryProvider;
import org.openksavi.sponge.spi.ProcessingUnitProvider;
import org.openksavi.sponge.trigger.TriggerAdapter;
import org.openksavi.sponge.util.PatternMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEngine
extends BaseEngineModule
implements Engine {
    private static final Logger logger = LoggerFactory.getLogger(BaseEngine.class);
    protected EngineModuleProvider moduleProvider;
    protected List<KnowledgeBaseInterpreterFactoryProvider> knowledgeBaseInterpreterFactoryProviders;
    protected EventQueueProvider eventQueueProvider;
    protected ProcessingUnitProvider processingUnitProvider;
    protected KnowledgeBaseFileProvider knowledgeBaseFileProvider;
    protected EventScheduler eventScheduler;
    protected EventQueueManager eventQueueManager;
    protected ThreadPoolManager threadPoolManager;
    protected KnowledgeBaseManager knowledgeBaseManager;
    protected PluginManager pluginManager;
    protected ConfigurationManager configurationManager;
    protected StatisticsManager statisticsManager;
    protected Session session = DefaultSession.createNewSession();
    protected Lock lock = new ReentrantLock(true);
    protected ProcessorManager processorManager;
    protected ProcessingUnitManager processingUnitManager;
    protected ActionManager actionManager;
    protected EventQueue inputQueue;
    private AtomicReference<Throwable> rememberedException = new AtomicReference();
    private String configurationFilename;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private KnowledgeBaseEngineOperations operations;
    private ExceptionHandler exceptionHandler = new LoggingExceptionHandler();
    private List<OnStartupListener> onStartupListeners = new ArrayList<OnStartupListener>();
    private List<OnShutdownListener> onShutdownListeners = new ArrayList<OnShutdownListener>();
    private VersionInfo versionInfo = new VersionInfo();
    private EngineParameters defaultParameters = new DefaultEngineParameters();
    private EventSetProcessorDurationStrategy durationStrategy = new QueuedEventSetProcessorDurationStrategy();
    private PatternMatcher patternMatcher = new RegexPatternMatcher();

    public BaseEngine() {
        this.setEngine(this);
    }

    public EngineModuleProvider getModuleProvider() {
        return this.moduleProvider;
    }

    public void setModuleProvider(EngineModuleProvider moduleProvider) {
        this.moduleProvider = moduleProvider;
    }

    public List<KnowledgeBaseInterpreterFactoryProvider> getKnowledgeBaseInterpreterFactoryProviders() {
        return this.knowledgeBaseInterpreterFactoryProviders;
    }

    public void setKnowledgeBaseInterpreterFactoryProviders(List<KnowledgeBaseInterpreterFactoryProvider> knowledgeBaseInterpreterFactoryProviders) {
        this.knowledgeBaseInterpreterFactoryProviders = knowledgeBaseInterpreterFactoryProviders;
    }

    public void setEventQueueProvider(EventQueueProvider eventQueueProvider) {
        this.eventQueueProvider = eventQueueProvider;
    }

    public void setProcessingUnitProvider(ProcessingUnitProvider processingUnitProvider) {
        this.processingUnitProvider = processingUnitProvider;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public String getConfigurationFilename() {
        return this.configurationFilename;
    }

    public void setConfigurationFilename(String configurationFilename) {
        this.configurationFilename = configurationFilename;
    }

    public void init() {
        this.lock.lock();
        try {
            if (this.initialized.get()) {
                return;
            }
            this.ensureProvidersSet();
            this.configurationManager = this.moduleProvider.createConfigurationManager((Engine)this, this.configurationFilename);
            this.pluginManager = this.moduleProvider.createPluginManager((Engine)this);
            this.knowledgeBaseManager = this.moduleProvider.createKnowledgeBaseManager((Engine)this);
            this.threadPoolManager = this.moduleProvider.createThreadPoolManager((Engine)this);
            this.processorManager = this.moduleProvider.createProcessorManager((Engine)this);
            this.actionManager = this.moduleProvider.createActionManager((Engine)this);
            this.statisticsManager = this.moduleProvider.createStatisticsManager((Engine)this);
            this.processingUnitManager = this.moduleProvider.createProcessingUnitManager((Engine)this);
            this.eventQueueManager = this.moduleProvider.createEventQueueManager((Engine)this);
            this.operations = new BaseKnowledgeBaseEngineOperations(this, this.knowledgeBaseManager.getDefaultKnowledgeBase());
            this.initialized.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void ensureProvidersSet() {
        if (this.moduleProvider == null) {
            this.moduleProvider = ServiceLoaderUtils.loadService(EngineModuleProvider.class);
            if (this.moduleProvider == null) {
                this.moduleProvider = new DefaultEngineModuleProvider();
            }
        }
        if (this.knowledgeBaseInterpreterFactoryProviders == null) {
            this.knowledgeBaseInterpreterFactoryProviders = ServiceLoaderUtils.loadServices(KnowledgeBaseInterpreterFactoryProvider.class);
        }
        if (this.eventQueueProvider == null) {
            this.eventQueueProvider = new DefaultEventQueueProvider();
        }
        if (this.processingUnitProvider == null) {
            this.processingUnitProvider = new DefaultProcessingUnitProvider();
        }
        if (this.knowledgeBaseFileProvider == null) {
            this.knowledgeBaseFileProvider = new DefaultKnowledgeBaseFileProvider();
        }
    }

    @Override
    public void doStartup() {
        this.lock.lock();
        try {
            logger.info("Starting up {}", (Object)this.getDescription());
            this.init();
            try {
                this.clearRememberedException();
                this.configurationManager.startup();
                this.configureEngineModules();
                this.eventQueueManager.startup();
                this.eventScheduler.startup();
                this.operations.event("startup").send();
                this.knowledgeBaseManager.startup();
                this.pluginManager.startup();
                this.onStartupListeners.forEach(listener -> listener.onStartup());
                this.knowledgeBaseManager.onStartup();
                this.threadPoolManager.startup();
                this.processingUnitManager.startup();
                logger.info("{} is running", (Object)this.getDescription());
            }
            catch (Throwable e) {
                this.safelyShutdownIfStartupError(new EngineModule[]{this.eventScheduler, this.threadPoolManager, this.processingUnitManager});
                throw Utils.wrapException("startup", e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void safelyShutdownIfStartupError(EngineModule ... modules) {
        Stream.of(modules).forEachOrdered(module -> {
            try {
                if (module != null) {
                    module.shutdown();
                }
            }
            catch (Throwable ex) {
                logger.warn(module.getName(), ex);
            }
        });
    }

    protected void setupEngineName() {
        if (this.getName() == null && this.configurationManager.getEngineName() != null) {
            this.setName(this.configurationManager.getEngineName());
        }
    }

    @Override
    public void doShutdown() {
        this.lock.lock();
        try {
            logger.info("Shutting down {}", (Object)this.getDescription());
            AtomicReference<Object> exceptionHolder = new AtomicReference<Object>(null);
            this.safelyShutdownModule((EngineModule)this.processingUnitManager, exceptionHolder);
            this.safelyShutdownModule((EngineModule)this.threadPoolManager, exceptionHolder);
            this.knowledgeBaseManager.onShutdown();
            this.onShutdownListeners.forEach(listener -> listener.onShutdown());
            this.safelyShutdownModule((EngineModule)this.pluginManager, exceptionHolder);
            this.safelyShutdownModule((EngineModule)this.knowledgeBaseManager, exceptionHolder);
            this.safelyShutdownModule((EngineModule)this.eventScheduler, exceptionHolder);
            this.safelyShutdownModule((EngineModule)this.eventQueueManager, exceptionHolder);
            if (exceptionHolder.get() != null) {
                throw (Throwable)exceptionHolder.get();
            }
            logger.info("{} is terminated", (Object)this.getDescription());
        }
        catch (Throwable e) {
            throw Utils.wrapException("shutdown", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void requestShutdown() {
        Utils.executeConcurrentlyOnce(this, () -> this.shutdown());
    }

    private void safelyShutdownModule(EngineModule module, AtomicReference<Throwable> exceptionHolder) {
        block2: {
            try {
                module.shutdown();
            }
            catch (Throwable e) {
                if (exceptionHolder.get() != null) break block2;
                exceptionHolder.set(e);
            }
        }
    }

    protected void configureEngineModules() {
        this.setupEngineName();
        this.knowledgeBaseManager.setKnowledgeBaseInterpreterFactoryProviders(this.knowledgeBaseInterpreterFactoryProviders);
        this.inputQueue = this.eventQueueProvider.getInputQueue();
        EventQueue mainProcessingQueue = this.eventQueueProvider.getMainQueue();
        EventQueue outputQueue = this.eventQueueProvider.getOutputQueue();
        this.eventQueueManager.setInputEventQueue(this.inputQueue);
        this.eventQueueManager.setMainEventQueue(mainProcessingQueue);
        this.eventQueueManager.setOutputEventQueue(outputQueue);
        this.inputQueue.setCapacity(this.configurationManager.getEventQueueCapacity());
        mainProcessingQueue.setCapacity(this.getDefaultParameters().getMainEventQueueCapacity());
        this.eventScheduler = this.moduleProvider.createEventScheduler((Engine)this, this.inputQueue);
        this.processingUnitManager.setFilterProcessingUnit(this.processingUnitProvider.createFilterProcessingUnit((Engine)this, this.inputQueue, mainProcessingQueue));
        this.processingUnitManager.setMainProcessingUnit(this.processingUnitProvider.createMainProcessingUnit((Engine)this, mainProcessingQueue, outputQueue));
        if (this.configurationManager.getRootConfig() != null) {
            this.pluginManager.configure(this.configurationManager.getRootConfig());
        }
        if (this.configurationManager.getRootConfig() != null) {
            this.knowledgeBaseManager.configure(this.configurationManager.getRootConfig());
        }
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public KnowledgeBaseManager getKnowledgeBaseManager() {
        return this.knowledgeBaseManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public EventScheduler getEventScheduler() {
        return this.eventScheduler;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public ProcessingUnitManager getProcessingUnitManager() {
        return this.processingUnitManager;
    }

    public ThreadPoolManager getThreadPoolManager() {
        return this.threadPoolManager;
    }

    public List<FilterAdapter> getFilters() {
        return new ArrayList<FilterAdapter>(this.getFilterProcessingUnit().getRegisteredProcessorAdapterMap().values());
    }

    public List<TriggerAdapter> getTriggers() {
        return this.getMainProcessingUnit().getTriggerAdapters();
    }

    public List<RuleAdapterGroup> getRuleGroups() {
        return this.getMainProcessingUnit().getRuleAdapterGroups();
    }

    public List<CorrelatorAdapterGroup> getCorrelatorGroups() {
        return this.getMainProcessingUnit().getCorrelatorAdapterGroups();
    }

    public List<ActionAdapter> getActions() {
        return new ArrayList<ActionAdapter>(this.actionManager.getRegisteredActionAdapterMap().values());
    }

    public void reload() {
        this.lock.lock();
        try {
            this.pluginManager.onBeforeReload();
            this.knowledgeBaseManager.reload();
            this.pluginManager.onAfterReload();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void requestReload() {
        Utils.executeConcurrentlyOnce(this, () -> this.reload());
    }

    public void handleError(ProcessorAdapter<?> processorAdapter, Throwable e) {
        this.handleError(processorAdapter != null && processorAdapter.getName() != null ? processorAdapter.getName() : "unknown", processorAdapter, e);
    }

    public void handleError(String sourceName, Throwable e) {
        this.handleError(sourceName, null, e);
    }

    protected void handleError(String sourceName, Object sourceObject, Throwable exception) {
        this.tryRememberException(exception);
        this.exceptionHandler.handleException(exception, (ExceptionContext)new GenericExceptionContext(this, (String)ObjectUtils.defaultIfNull((Object)Utils.getSourceName(exception), (Object)sourceName), sourceObject));
    }

    public List<Plugin> getPlugins() {
        return this.pluginManager.getPlugins();
    }

    public String getVersion() {
        return this.versionInfo.getVersion();
    }

    public String getDescription() {
        return this.versionInfo.getDescription(this.getName());
    }

    protected void tryRememberException(Throwable e) {
        this.rememberedException.updateAndGet(previous -> previous != null ? previous : e);
    }

    public void clearRememberedException() {
        this.rememberedException.set(null);
    }

    public EventQueueManager getEventQueueManager() {
        return this.eventQueueManager;
    }

    public ProcessingUnit<FilterAdapter> getFilterProcessingUnit() {
        return this.processingUnitManager.getFilterProcessingUnit();
    }

    public MainProcessingUnit getMainProcessingUnit() {
        return this.processingUnitManager.getMainProcessingUnit();
    }

    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public EventQueue getInputQueue() {
        return this.inputQueue;
    }

    public AtomicReference<Throwable> getRememberedException() {
        return this.rememberedException;
    }

    public boolean isError() {
        return this.rememberedException.get() != null;
    }

    public Throwable getError() {
        return this.rememberedException.get();
    }

    public KnowledgeBaseEngineOperations getOperations() {
        return this.operations;
    }

    public Session getSession() {
        return this.session;
    }

    public KnowledgeBaseFileProvider getKnowledgeBaseFileProvider() {
        return this.knowledgeBaseFileProvider;
    }

    public void setKnowledgeBaseFileProvider(KnowledgeBaseFileProvider knowledgeBaseFileProvider) {
        this.knowledgeBaseFileProvider = knowledgeBaseFileProvider;
    }

    public void addOnStartupListener(OnStartupListener onStartupListener) {
        this.onStartupListeners.add(onStartupListener);
    }

    public boolean removeOnStartupListener(OnStartupListener onStartupListener) {
        return this.onStartupListeners.remove(onStartupListener);
    }

    public List<OnStartupListener> getOnStartupListeners() {
        return this.onStartupListeners;
    }

    public void addOnShutdownListener(OnShutdownListener onShutdownListener) {
        this.onShutdownListeners.add(onShutdownListener);
    }

    public boolean removeOnShutdownListener(OnShutdownListener onShutdownListener) {
        return this.onShutdownListeners.remove(onShutdownListener);
    }

    public List<OnShutdownListener> getOnShutdownListeners() {
        return this.onShutdownListeners;
    }

    public EngineParameters getDefaultParameters() {
        return this.defaultParameters;
    }

    public EventSetProcessorDurationStrategy getEventSetProcessorDurationStrategy() {
        return this.durationStrategy;
    }

    public void setEventSetProcessorDurationStrategy(EventSetProcessorDurationStrategy durationStrategy) {
        this.durationStrategy = durationStrategy;
    }

    public PatternMatcher getPatternMatcher() {
        return this.patternMatcher;
    }

    public void setPatternMatcher(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }
}

