/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.List;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.engine.EventQueueManager;
import org.openksavi.sponge.engine.event.EventQueue;
import org.openksavi.sponge.shaded.com.google.common.collect.ImmutableList;

public class DefaultEventQueueManager
extends BaseEngineModule
implements EventQueueManager {
    private EventQueue inputEventQueue;
    private EventQueue mainEventQueue;
    private EventQueue outputEventQueue;

    public DefaultEventQueueManager(Engine engine) {
        super("EventQueueManager", engine);
    }

    @Override
    public void doStartup() {
        this.getEventQueues().forEach(queue -> queue.setEngine(this.getEngine()));
        this.outputEventQueue.startup();
        this.mainEventQueue.startup();
        this.inputEventQueue.startup();
    }

    @Override
    public void doShutdown() {
        this.inputEventQueue.shutdown();
        this.mainEventQueue.shutdown();
        this.outputEventQueue.shutdown();
    }

    public EventQueue getInputEventQueue() {
        return this.inputEventQueue;
    }

    public void setInputEventQueue(EventQueue inputEventQueue) {
        this.inputEventQueue = inputEventQueue;
    }

    public EventQueue getMainEventQueue() {
        return this.mainEventQueue;
    }

    public void setMainEventQueue(EventQueue mainEventQueue) {
        this.mainEventQueue = mainEventQueue;
    }

    public EventQueue getOutputEventQueue() {
        return this.outputEventQueue;
    }

    public void setOutputEventQueue(EventQueue outputEventQueue) {
        this.outputEventQueue = outputEventQueue;
    }

    public List<EventQueue> getEventQueues() {
        return ImmutableList.of(this.inputEventQueue, this.mainEventQueue, this.outputEventQueue);
    }
}

