/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.kb.DefaultKnowledgeBase;
import org.openksavi.sponge.core.kb.DefaultScriptKnowledgeBase;
import org.openksavi.sponge.core.kb.FileKnowledgeBaseScript;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.engine.KnowledgeBaseManager;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;
import org.openksavi.sponge.kb.KnowledgeBaseScript;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.kb.ScriptKnowledgeBase;
import org.openksavi.sponge.kb.ScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.spi.KnowledgeBaseInterpreterFactory;
import org.openksavi.sponge.spi.KnowledgeBaseInterpreterFactoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKnowledgeBaseManager
extends BaseEngineModule
implements KnowledgeBaseManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultKnowledgeBaseManager.class);
    private static final String CFG_KNOWLEDGE_BASES = "knowledgeBases";
    private static final String CFG_KNOWLEDGE_BASE_ATTR_NAME = "name";
    private static final String CFG_KNOWLEDGE_BASE_ATTR_TYPE = "type";
    private static final String CFG_KNOWLEDGE_BASE_FILE = "file";
    private static final String CFG_KB_FILE_ATTR_CHARSET = "charset";
    private static final String CFG_KB_FILE_ATTR_REQUIRED = "required";
    protected Map<String, KnowledgeBaseInterpreterFactory> knowledgeBaseInterpreterFactories = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, KnowledgeBase> knowledgeBases = Collections.synchronizedMap(new LinkedHashMap());
    protected KnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase();

    public DefaultKnowledgeBaseManager(Engine engine) {
        super("KnowledgeBaseManager", engine);
        this.knowledgeBases.put(this.defaultKnowledgeBase.getName(), this.defaultKnowledgeBase);
    }

    public void configure(Configuration configuration) {
        Configuration[] knowledgeBaseNodes;
        for (Configuration knowledgeBaseNode : knowledgeBaseNodes = configuration.getChildConfigurationsOf(CFG_KNOWLEDGE_BASES)) {
            DefaultScriptKnowledgeBase knowledgeBase = this.createScriptKnowledgeBaseFromConfiguration(knowledgeBaseNode);
            this.addKnowledgeBase(knowledgeBase);
        }
    }

    protected DefaultScriptKnowledgeBase createScriptKnowledgeBaseFromConfiguration(Configuration configuration) {
        String name = configuration.getAttribute(CFG_KNOWLEDGE_BASE_ATTR_NAME, null);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new SpongeException("Knowledge Base name must not be empty");
        }
        String typeCode = configuration.getAttribute(CFG_KNOWLEDGE_BASE_ATTR_TYPE, null);
        if (StringUtils.isEmpty((CharSequence)typeCode)) {
            throw new SpongeException("Knowledge base type must not be empty");
        }
        DefaultScriptKnowledgeBase knowledgeBase = new DefaultScriptKnowledgeBase(name, this.getKnowledgeBaseInterpreterFactory(typeCode).getSupportedType());
        for (Configuration fileNode : configuration.getConfigurationsAt(CFG_KNOWLEDGE_BASE_FILE)) {
            String fileName = fileNode.getValue();
            if (StringUtils.isEmpty((CharSequence)fileName)) {
                throw new SpongeException("Knowledge base file name must not be empty");
            }
            knowledgeBase.addScript(new FileKnowledgeBaseScript(fileName, fileNode.getAttribute(CFG_KB_FILE_ATTR_CHARSET, null), fileNode.getBooleanAttribute(CFG_KB_FILE_ATTR_REQUIRED, Boolean.valueOf(true))));
        }
        return knowledgeBase;
    }

    public void reload() {
        this.onBeforeReload();
        this.knowledgeBases.values().forEach(knowledgeBase -> {
            if (knowledgeBase instanceof ScriptKnowledgeBase) {
                ((ScriptKnowledgeBase)knowledgeBase).reload();
            }
        });
        this.onLoad();
        this.onAfterReload();
    }

    @Override
    public void doStartup() {
        this.onInit();
        this.onLoad();
    }

    @Override
    public void doShutdown() {
        this.onClear();
    }

    public void onInit() {
        this.onInitializeKnowledgeBases();
    }

    public void onLoad() {
        this.knowledgeBases.values().forEach(kb -> kb.onLoad());
    }

    public void onClear() {
        this.knowledgeBases.values().forEach(kb -> kb.onClear());
    }

    public void onStartup() {
        this.knowledgeBases.values().forEach(kb -> kb.onStartup());
    }

    public void onShutdown() {
        this.knowledgeBases.values().forEach(kb -> kb.onShutdown());
    }

    public void onBeforeReload() {
        this.knowledgeBases.values().forEach(kb -> kb.onBeforeReload());
    }

    public void onAfterReload() {
        this.knowledgeBases.values().forEach(kb -> kb.onAfterReload());
    }

    protected void onInitializeKnowledgeBases() {
        for (KnowledgeBase knowledgeBase : this.knowledgeBases.values()) {
            if (knowledgeBase instanceof ScriptKnowledgeBase) {
                ScriptKnowledgeBase scriptKnowledgeBase = (ScriptKnowledgeBase)knowledgeBase;
                if (knowledgeBase.getType() == null) {
                    knowledgeBase.setType(this.inferKnowledgeBaseType(scriptKnowledgeBase));
                }
                this.verifyKnowledgeBaseFileTypes(scriptKnowledgeBase);
            }
            if (knowledgeBase.getInterpreter() == null) {
                knowledgeBase.setInterpreter(this.createKnowledgeBaseInterpreter(knowledgeBase.getType().getTypeCode(), knowledgeBase));
            }
            if (knowledgeBase instanceof ScriptKnowledgeBase) {
                ((ScriptKnowledgeBase)knowledgeBase).load();
            }
            knowledgeBase.onInit();
        }
    }

    public void addKnowledgeBase(KnowledgeBase knowledgeBase) {
        if (this.knowledgeBases.containsKey(knowledgeBase.getName())) {
            throw new SpongeException("Knowledge base '" + knowledgeBase.getName() + "' already exists");
        }
        this.knowledgeBases.put(knowledgeBase.getName(), knowledgeBase);
    }

    public Throwable unwrapKnowledgeBaseException(Throwable exception) {
        for (KnowledgeBase knowledgeBase : this.knowledgeBases.values()) {
            ScriptKnowledgeBaseInterpreter interpreter;
            if (!(knowledgeBase instanceof ScriptKnowledgeBase) || !(interpreter = ((ScriptKnowledgeBase)knowledgeBase).getInterpreter()).isKnowledgeBaseException(exception)) continue;
            return interpreter.getJavaException(exception);
        }
        return null;
    }

    public void setKnowledgeBaseInterpreterFactoryProviders(List<KnowledgeBaseInterpreterFactoryProvider> providers) {
        providers.forEach(provider -> {
            KnowledgeBaseInterpreterFactory factory = provider.getKnowledgeBaseInterpreterFactory();
            this.knowledgeBaseInterpreterFactories.put(factory.getSupportedType().getTypeCode(), factory);
        });
    }

    protected KnowledgeBaseInterpreterFactory getKnowledgeBaseInterpreterFactory(String typeCode) {
        KnowledgeBaseInterpreterFactory factory = this.knowledgeBaseInterpreterFactories.get(typeCode);
        if (factory == null) {
            throw new SpongeException("No knowledge base interpreter factory registered for type code '" + typeCode + "'");
        }
        return factory;
    }

    public KnowledgeBaseInterpreter createKnowledgeBaseInterpreter(String typeCode, KnowledgeBase knowledgeBase) {
        return this.getKnowledgeBaseInterpreterFactory(typeCode).createKnowledgeBaseInterpreter(this.getEngine(), knowledgeBase);
    }

    public KnowledgeBase getKnowledgeBase(String name) {
        KnowledgeBase result = this.knowledgeBases.get(name);
        if (result == null) {
            throw new IllegalArgumentException("Unknown knowledge base of name " + name);
        }
        return result;
    }

    public ScriptKnowledgeBase getScriptKnowledgeBase(String name) {
        return (ScriptKnowledgeBase)this.getKnowledgeBase(name);
    }

    public KnowledgeBase getMainKnowledgeBase() {
        return this.knowledgeBases.values().stream().filter(knowledgeBase -> knowledgeBase != this.defaultKnowledgeBase).findFirst().get();
    }

    public List<KnowledgeBase> getKnowledgeBases() {
        return new ArrayList<KnowledgeBase>(this.knowledgeBases.values());
    }

    public KnowledgeBase getDefaultKnowledgeBase() {
        return this.defaultKnowledgeBase;
    }

    public void setInterpreterGlobalVariable(String name, Object value) {
        this.knowledgeBases.values().forEach(knowledgeBase -> knowledgeBase.getInterpreter().setVariable(name, value));
    }

    public KnowledgeBaseType inferKnowledgeBaseType(ScriptKnowledgeBase scriptKnowledgeBase) {
        List scripts = scriptKnowledgeBase.getScripts();
        if (scripts.isEmpty()) {
            throw new SpongeException("Cannot infer knowledge base '" + scriptKnowledgeBase.getName() + "' type because it has no files");
        }
        String fileName = ((KnowledgeBaseScript)scripts.get(0)).getFileName();
        String extension = FilenameUtils.getExtension((String)fileName);
        Optional<KnowledgeBaseType> typeO = this.knowledgeBaseInterpreterFactories.values().stream().filter(factory -> StringUtils.equalsIgnoreCase((CharSequence)factory.getSupportedType().getFileExtension(), (CharSequence)extension)).map(factory -> factory.getSupportedType()).findFirst();
        if (!typeO.isPresent()) {
            throw new SpongeException("Unsupported file extension '" + extension + "' for file '" + fileName + "' in knowledge base '" + scriptKnowledgeBase.getName() + "'");
        }
        return typeO.get();
    }

    public void verifyKnowledgeBaseFileTypes(ScriptKnowledgeBase scriptKnowledgeBase) {
        String extension = scriptKnowledgeBase.getType().getFileExtension();
        if (!scriptKnowledgeBase.getScripts().stream().allMatch(script -> StringUtils.equalsIgnoreCase((CharSequence)FilenameUtils.getExtension((String)script.getFileName()), (CharSequence)extension))) {
            logger.warn("Different file extensions found for files in knowledge base '" + scriptKnowledgeBase.getName() + "'");
        }
    }
}

