/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.EventProcessorAdapter;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.ProcessorAdapterFactory;
import org.openksavi.sponge.ProcessorDefinition;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.core.BaseProcessorAdapter;
import org.openksavi.sponge.core.BaseProcessorDefinition;
import org.openksavi.sponge.core.correlator.BaseCorrelatorAdapter;
import org.openksavi.sponge.core.correlator.BaseCorrelatorAdapterGroup;
import org.openksavi.sponge.core.engine.BaseEngine;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.kb.BaseKnowledgeBase;
import org.openksavi.sponge.core.rule.BaseRuleAdapter;
import org.openksavi.sponge.core.rule.BaseRuleAdapterGroup;
import org.openksavi.sponge.core.util.Utils;
import org.openksavi.sponge.correlator.CorrelatorAdapter;
import org.openksavi.sponge.correlator.CorrelatorAdapterGroup;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.engine.ProcessorManager;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.engine.processing.EventSetProcessorMainProcessingUnitHandler;
import org.openksavi.sponge.filter.FilterAdapter;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.rule.RuleAdapter;
import org.openksavi.sponge.rule.RuleAdapterGroup;
import org.openksavi.sponge.trigger.TriggerAdapter;

public class DefaultProcessorManager
extends BaseEngineModule
implements ProcessorManager {
    protected Map<ProcessorType, RegistrationHandler> registrationHandlers = Utils.immutableMapOf(ProcessorType.ACTION, new RegistrationHandler(adapter -> this.getEngine().getActionManager().addAction((ActionAdapter)adapter), adapter -> this.getEngine().getActionManager().removeAction(adapter.getName()), adapter -> this.getEngine().getActionManager().existsAction(adapter.getName())), ProcessorType.FILTER, new RegistrationHandler(adapter -> this.getEngine().getFilterProcessingUnit().addProcessor((EventProcessorAdapter)((FilterAdapter)adapter)), adapter -> this.getEngine().getFilterProcessingUnit().removeProcessor(adapter.getName()), adapter -> this.getEngine().getFilterProcessingUnit().existsProcessor(adapter.getName())), ProcessorType.TRIGGER, new RegistrationHandler(adapter -> this.getEngine().getMainProcessingUnit().addProcessor((EventProcessorAdapter)((TriggerAdapter)adapter)), adapter -> this.getEngine().getMainProcessingUnit().removeProcessor(adapter.getName()), adapter -> this.getEngine().getMainProcessingUnit().existsProcessor(adapter.getName(), adapter.getType())), ProcessorType.RULE, new RegistrationHandler(adapter -> this.getEngine().getMainProcessingUnit().addProcessor((EventProcessorAdapter)new BaseRuleAdapterGroup((BaseRuleAdapter)adapter, (EventSetProcessorMainProcessingUnitHandler<RuleAdapterGroup, RuleAdapter>)((EventSetProcessorMainProcessingUnitHandler)this.getEngine().getMainProcessingUnit().getHandler(ProcessorType.RULE_GROUP)))), adapter -> this.getEngine().getMainProcessingUnit().removeProcessor(adapter.getName()), adapter -> this.getEngine().getMainProcessingUnit().existsProcessor(adapter.getName(), ProcessorType.RULE_GROUP)), ProcessorType.CORRELATOR, new RegistrationHandler(adapter -> this.getEngine().getMainProcessingUnit().addProcessor((EventProcessorAdapter)new BaseCorrelatorAdapterGroup((BaseCorrelatorAdapter)adapter, (EventSetProcessorMainProcessingUnitHandler<CorrelatorAdapterGroup, CorrelatorAdapter>)((EventSetProcessorMainProcessingUnitHandler)this.getEngine().getMainProcessingUnit().getHandler(ProcessorType.CORRELATOR_GROUP)))), adapter -> this.getEngine().getMainProcessingUnit().removeProcessor(adapter.getName()), adapter -> this.getEngine().getMainProcessingUnit().existsProcessor(adapter.getName(), ProcessorType.CORRELATOR_GROUP)));
    private Lock lock = new ReentrantLock(true);

    public DefaultProcessorManager(Engine engine) {
        super("ProcessorManager", engine);
    }

    @Override
    public BaseEngine getEngine() {
        return (BaseEngine)super.getEngine();
    }

    public void enable(KnowledgeBase knowledgeBase, Object processorClass) {
        this.doEnable(knowledgeBase, processorClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEnable(KnowledgeBase knowledgeBase, Object processorClass, ProcessorType requiredType) {
        this.lock.lock();
        try {
            InstanceHolder instanceHolder = this.createProcessorInstanceByProcessorClass(knowledgeBase, processorClass, Processor.class);
            BaseProcessorAdapter adapter = this.createAdapter(instanceHolder, requiredType);
            this.bindAdapter(knowledgeBase, instanceHolder.getName(), instanceHolder.getProcessor(), adapter);
            this.initializeProcessor(instanceHolder, adapter);
            this.getRegistrationHandler(adapter.getType()).register(adapter);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disable(KnowledgeBase knowledgeBase, Object processorClass) {
        this.doDisable(knowledgeBase, processorClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisable(KnowledgeBase knowledgeBase, Object processorClass, ProcessorType requiredType) {
        this.lock.lock();
        try {
            InstanceHolder instanceHolder = this.createProcessorInstanceByProcessorClass(knowledgeBase, processorClass, Processor.class);
            BaseProcessorAdapter adapter = this.createAdapter(instanceHolder, requiredType);
            this.bindAdapter(knowledgeBase, instanceHolder.getName(), instanceHolder.getProcessor(), adapter);
            this.getRegistrationHandler(adapter.getType()).deregister(adapter);
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T extends Processor> T createProcessorInstance(ProcessorDefinition definition, Class<T> cls) {
        Validate.isInstanceOf(BaseProcessorDefinition.class, (Object)definition, (String)"Processor definition must be or extend %s", (Object[])new Object[]{BaseProcessorDefinition.class});
        if (((BaseProcessorDefinition)definition).isJavaDefined()) {
            try {
                return (T)((Processor)Class.forName(definition.getName()).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw Utils.wrapException("createProcessorInstance", e);
            }
        }
        return (T)definition.getKnowledgeBase().getInterpreter().createProcessorInstance(definition.getName(), cls);
    }

    protected InstanceHolder createProcessorInstanceByProcessorClass(KnowledgeBase knowledgeBase, Object processorClass, Class javaClass) {
        Validate.notNull((Object)processorClass, (String)"Processor class cannot be null", (Object[])new Object[0]);
        String name = knowledgeBase.getInterpreter().getScriptKnowledgeBaseProcessorClassName(processorClass);
        if (name != null) {
            return new InstanceHolder(knowledgeBase.getInterpreter().createProcessorInstance(name, javaClass), name, false);
        }
        if (processorClass instanceof Class) {
            Class destJavaClass = (Class)processorClass;
            if (!javaClass.isAssignableFrom(destJavaClass)) {
                throw new SpongeException("Unsupported processor specification: " + destJavaClass.getName() + " can't be used as " + javaClass.getName());
            }
            try {
                return new InstanceHolder((Processor)destJavaClass.newInstance(), destJavaClass.getName(), true);
            }
            catch (Throwable e) {
                throw Utils.wrapException(destJavaClass.getName(), e);
            }
        }
        throw new SpongeException("Unsupported processor class: " + processorClass);
    }

    protected BaseProcessorAdapter createAdapter(InstanceHolder instanceHolder, ProcessorType requiredType) {
        Processor processor = instanceHolder.getProcessor();
        Validate.isInstanceOf(ProcessorAdapterFactory.class, (Object)processor, (String)"Processor must implement %s", (Object[])new Object[]{ProcessorAdapterFactory.class});
        ProcessorAdapter adapter = ((ProcessorAdapterFactory)processor).createAdapter();
        Validate.isInstanceOf(BaseProcessorAdapter.class, (Object)adapter, (String)"Processor adapter must extend %s", (Object[])new Object[]{BaseProcessorAdapter.class});
        BaseProcessorAdapter result = (BaseProcessorAdapter)adapter;
        result.getDefinition().setJavaDefined(instanceHolder.isJavaDefined());
        if (requiredType != null) {
            Validate.isTrue((adapter.getType() == requiredType ? 1 : 0) != 0, (String)"% is % but should be %", (Object[])new Object[]{adapter.getName(), adapter.getType().getDisplayName(), requiredType.getDisplayName()});
        }
        return result;
    }

    protected void bindAdapter(KnowledgeBase knowledgeBase, String name, Processor processor, BaseProcessorAdapter adapter) {
        adapter.setKnowledgeBase((BaseKnowledgeBase)knowledgeBase);
        adapter.setProcessor(processor);
        processor.setName(name);
    }

    protected void initializeProcessor(InstanceHolder instanceHolder, BaseProcessorAdapter adapter) {
        Processor processor = instanceHolder.getProcessor();
        processor.onConfigure();
        Optional<Map.Entry<ProcessorType, RegistrationHandler>> alreadyRegistered = this.findAlreadyRegisteredByDifferentType(adapter);
        if (alreadyRegistered.isPresent()) {
            Validate.isTrue((boolean)false, (String)"% named '%' has already been registered as % type", (Object[])new Object[]{adapter.getType().getDisplayName(), adapter.getName(), alreadyRegistered.get().getKey().getDisplayName()});
        }
        processor.getAdapter().validate();
        if (processor.getAdapter().getDefinition().isSingleton()) {
            processor.onInit();
        }
    }

    protected Optional<Map.Entry<ProcessorType, RegistrationHandler>> findAlreadyRegisteredByDifferentType(ProcessorAdapter adapter) {
        return this.registrationHandlers.entrySet().stream().filter(entry -> !((ProcessorType)entry.getKey()).equals((Object)adapter.getType()) && ((RegistrationHandler)entry.getValue()).exists(adapter)).findFirst();
    }

    protected RegistrationHandler getRegistrationHandler(ProcessorType type) {
        return (RegistrationHandler)Validate.notNull((Object)this.registrationHandlers.get(type), (String)"Unsupported processor type %s", (Object[])new Object[]{type});
    }

    public void enableAction(KnowledgeBase knowledgeBase, Object actionClass) {
        this.doEnable(knowledgeBase, actionClass, ProcessorType.ACTION);
    }

    public void enableFilter(KnowledgeBase knowledgeBase, Object filterClass) {
        this.doEnable(knowledgeBase, filterClass, ProcessorType.FILTER);
    }

    public void enableTrigger(KnowledgeBase knowledgeBase, Object triggerClass) {
        this.doEnable(knowledgeBase, triggerClass, ProcessorType.TRIGGER);
    }

    public void enableRule(KnowledgeBase knowledgeBase, Object ruleClass) {
        this.doEnable(knowledgeBase, ruleClass, ProcessorType.RULE);
    }

    public void enableCorrelator(KnowledgeBase knowledgeBase, Object correlatorClass) {
        this.doEnable(knowledgeBase, correlatorClass, ProcessorType.CORRELATOR);
    }

    public void disableAction(KnowledgeBase knowledgeBase, Object actionClass) {
        this.doDisable(knowledgeBase, actionClass, ProcessorType.ACTION);
    }

    public void disableFilter(KnowledgeBase knowledgeBase, Object filterClass) {
        this.doDisable(knowledgeBase, filterClass, ProcessorType.FILTER);
    }

    public void disableTrigger(KnowledgeBase knowledgeBase, Object triggerClass) {
        this.doDisable(knowledgeBase, triggerClass, ProcessorType.TRIGGER);
    }

    public void disableRule(KnowledgeBase knowledgeBase, Object ruleClass) {
        this.doDisable(knowledgeBase, ruleClass, ProcessorType.RULE);
    }

    public void disableCorrelator(KnowledgeBase knowledgeBase, Object correlatorClass) {
        this.doDisable(knowledgeBase, correlatorClass, ProcessorType.CORRELATOR);
    }

    protected String resolveProcessorName(KnowledgeBase knowledgeBase, Object processorClass, Class javaClass) {
        Validate.notNull((Object)processorClass, (String)"Processor class cannot be null", (Object[])new Object[0]);
        String name = knowledgeBase.getInterpreter().getScriptKnowledgeBaseProcessorClassName(processorClass);
        if (name != null) {
            return name;
        }
        if (processorClass instanceof Class) {
            Class destJavaClass = (Class)processorClass;
            if (!javaClass.isAssignableFrom(destJavaClass)) {
                throw new SpongeException("Unsupported processor specification: " + destJavaClass.getName() + " can't be used as " + javaClass.getName());
            }
            return destJavaClass.getName();
        }
        throw new SpongeException("Unsupported processor class: " + processorClass);
    }

    protected static class InstanceHolder {
        private Processor processor;
        private String name;
        private boolean javaDefined;

        public InstanceHolder(Processor processor, String name, boolean javaDefined) {
            this.processor = processor;
            this.name = name;
            this.javaDefined = javaDefined;
        }

        public Processor getProcessor() {
            return this.processor;
        }

        public void setProcessor(Processor processor) {
            this.processor = processor;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isJavaDefined() {
            return this.javaDefined;
        }

        public void setJavaDefined(boolean javaDefined) {
            this.javaDefined = javaDefined;
        }
    }

    protected static class RegistrationHandler {
        private Consumer<ProcessorAdapter> registration;
        private Consumer<ProcessorAdapter> deregistration;
        private Predicate<ProcessorAdapter> existence;

        public RegistrationHandler(Consumer<ProcessorAdapter> registration, Consumer<ProcessorAdapter> deregistration, Predicate<ProcessorAdapter> existence) {
            this.registration = registration;
            this.deregistration = deregistration;
            this.existence = existence;
        }

        public void register(ProcessorAdapter adapter) {
            this.registration.accept(adapter);
        }

        public void deregister(ProcessorAdapter adapter) {
            this.deregistration.accept(adapter);
        }

        public boolean exists(ProcessorAdapter adapter) {
            return this.existence.test(adapter);
        }
    }
}

