/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.event;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openksavi.sponge.core.engine.event.BaseEventQueue;
import org.openksavi.sponge.core.engine.event.PriorityEventQueueComparator;
import org.openksavi.sponge.engine.QueueFullException;
import org.openksavi.sponge.event.Event;

public class PriorityEventQueue
extends BaseEventQueue {
    protected static final int QUEUE_INITIAL_CAPACITY = 100;
    private BlockingQueue<Event> queue;
    private Lock lock = new ReentrantLock(true);

    public PriorityEventQueue(String name) {
        super(name);
        this.queue = this.createBlockingQueue();
    }

    protected BlockingQueue<Event> createBlockingQueue() {
        return new PriorityBlockingQueue<Event>(100, new PriorityEventQueueComparator());
    }

    public void put(Event event) throws QueueFullException {
        this.lock.lock();
        try {
            if (this.capacity > -1 && this.queue.size() >= this.capacity) {
                throw new QueueFullException("Event queue " + this.getName() + " is full. Capacity is " + this.capacity + ".");
            }
            this.queue.add(event);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Event get(long timeout) throws InterruptedException {
        return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    public int getSize() {
        return this.queue.size();
    }

    public void clear() {
        this.queue.clear();
    }
}

