/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.interactive;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import org.openksavi.sponge.core.util.Utils;
import org.openksavi.sponge.engine.interactive.InteractiveModeConsole;

public class SimpleInteractiveModeConsole
implements InteractiveModeConsole {
    private Console console;
    private BufferedReader reader;

    public SimpleInteractiveModeConsole(boolean open) {
        if (open) {
            this.open();
        }
    }

    public SimpleInteractiveModeConsole() {
        this(false);
    }

    public void open() {
        this.console = System.console();
        this.reader = this.console != null ? new BufferedReader(this.console.reader()) : new BufferedReader(new InputStreamReader(System.in));
    }

    public boolean isOpen() {
        return this.reader != null;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw Utils.wrapException("close", e);
        }
        finally {
            this.reader = null;
        }
    }

    public void print(String text) {
        if (this.console != null) {
            this.console.printf(text, new Object[0]);
        } else {
            System.out.print(text);
        }
    }

    public String readLine() throws IOException {
        this.print("> ");
        return this.reader.readLine();
    }
}

