/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.processing;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openksavi.sponge.EventProcessorAdapter;
import org.openksavi.sponge.EventSetProcessorAdapterGroup;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.engine.processing.BaseProcessingUnit;
import org.openksavi.sponge.core.engine.processing.SyncAsyncEventSetProcessorMainProcessingUnitHandler;
import org.openksavi.sponge.core.engine.processing.TriggerMainProcessingUnitHandler;
import org.openksavi.sponge.correlator.CorrelatorAdapterGroup;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.engine.event.EventQueue;
import org.openksavi.sponge.engine.processing.EventSetProcessorMainProcessingUnitHandler;
import org.openksavi.sponge.engine.processing.MainProcessingUnit;
import org.openksavi.sponge.engine.processing.MainProcessingUnitHandler;
import org.openksavi.sponge.rule.RuleAdapterGroup;
import org.openksavi.sponge.trigger.TriggerAdapter;

public abstract class BaseMainProcessingUnit
extends BaseProcessingUnit<EventProcessorAdapter<?>>
implements MainProcessingUnit {
    protected Map<ProcessorType, MainProcessingUnitHandler> handlers = Collections.synchronizedMap(new LinkedHashMap());

    protected BaseMainProcessingUnit(String name, Engine engine, EventQueue inQueue, EventQueue outQueue) {
        super(name, engine, inQueue, outQueue);
        this.createHandlers();
    }

    protected void createHandlers() {
        this.handlers.put(ProcessorType.TRIGGER, new TriggerMainProcessingUnitHandler(this));
        this.handlers.put(ProcessorType.RULE_GROUP, new SyncAsyncEventSetProcessorMainProcessingUnitHandler(ProcessorType.RULE_GROUP, this));
        this.handlers.put(ProcessorType.CORRELATOR_GROUP, new SyncAsyncEventSetProcessorMainProcessingUnitHandler(ProcessorType.CORRELATOR_GROUP, this));
    }

    protected void startupHandlers() {
        this.handlers.values().forEach(handler -> handler.startup());
    }

    protected void shutdownHandlers() {
        this.handlers.values().forEach(handler -> handler.shutdown());
    }

    protected <A extends ProcessorAdapter<?>> List<A> getProcessorAdapterList(ProcessorType type) {
        return this.getRegisteredProcessorAdapterMap().values().stream().filter(adapter -> adapter.getType() == type).map(adapter -> adapter).collect(Collectors.toList());
    }

    public boolean existsProcessor(String name, ProcessorType type) {
        return this.getRegisteredProcessorAdapterMap().values().stream().filter(adapter -> adapter.getType() == type && StringUtils.equals((CharSequence)adapter.getName(), (CharSequence)name)).findAny().isPresent();
    }

    public List<TriggerAdapter> getTriggerAdapters() {
        return this.getProcessorAdapterList(ProcessorType.TRIGGER);
    }

    public List<RuleAdapterGroup> getRuleAdapterGroups() {
        return this.getProcessorAdapterList(ProcessorType.RULE_GROUP);
    }

    public List<CorrelatorAdapterGroup> getCorrelatorAdapterGroups() {
        return this.getProcessorAdapterList(ProcessorType.CORRELATOR_GROUP);
    }

    public MainProcessingUnitHandler getHandler(ProcessorType type) {
        MainProcessingUnitHandler handler = this.handlers.get(type);
        if (handler == null) {
            throw new SpongeException("Handler for type " + type + " not registered");
        }
        return handler;
    }

    public Map<ProcessorType, MainProcessingUnitHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    protected void processorChanged(EventProcessorAdapter oldProcessor, EventProcessorAdapter newProcessor) {
        if (oldProcessor instanceof EventSetProcessorAdapterGroup) {
            ((EventSetProcessorMainProcessingUnitHandler)this.getHandler(oldProcessor.getType())).removeDurations((EventSetProcessorAdapterGroup)oldProcessor);
        }
    }
}

