/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.event;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.event.BaseEvent;
import org.openksavi.sponge.core.util.Utils;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventClonePolicy;

public class AttributeMapEvent
extends BaseEvent {
    private static final long serialVersionUID = -34279287157404032L;
    private Map<String, Object> attributes = Collections.synchronizedMap(new LinkedHashMap());

    public AttributeMapEvent(String name, EventClonePolicy clonePolicy) {
        super(name, clonePolicy);
    }

    public Object get(String name) {
        return this.attributes.get(name);
    }

    public Event set(String name, Object value) {
        this.valudateAttribute(name, value);
        this.attributes.put(name, value);
        return this;
    }

    public boolean has(String name) {
        return this.attributes.containsKey(name);
    }

    public Map<String, Object> getAll() {
        return this.attributes;
    }

    @Override
    public AttributeMapEvent clone() {
        AttributeMapEvent event = (AttributeMapEvent)super.clone();
        if (this.attributes != null) {
            switch (this.clonePolicy) {
                case SHALLOW: {
                    event.attributes = Collections.synchronizedMap(new LinkedHashMap<String, Object>(this.attributes));
                    break;
                }
                case DEEP: {
                    event.attributes = (Map)((Object)Utils.deepClone((Serializable)((Object)this.attributes)));
                    break;
                }
                default: {
                    throw new SpongeException("Unsupported value: " + this.clonePolicy);
                }
            }
        }
        return event;
    }
}

