/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.event;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventClonePolicy;

public abstract class BaseEvent
implements Event {
    private static final long serialVersionUID = -2269323477538266057L;
    public static final int DEFAULT_PRIORITY = 0;
    protected String id;
    protected Instant time;
    protected String name;
    protected EventClonePolicy clonePolicy;

    protected BaseEvent(String name, EventClonePolicy clonePolicy) {
        if (name == null) {
            throw new IllegalArgumentException("Event name cannot be null");
        }
        this.name = name;
        this.clonePolicy = clonePolicy;
    }

    public String getName() {
        return this.name;
    }

    public Instant getTime() {
        return this.time;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getPriority() {
        return 0;
    }

    public <T> T get(String name, Class<T> cls) {
        return (T)this.get(name);
    }

    public boolean equalsById(Event event) {
        return event != null && Objects.equals(this.id, event.getId());
    }

    public boolean equalsByAttributes(Event event) {
        if (event == null) {
            return false;
        }
        if (event == this) {
            return true;
        }
        return Objects.equals(this.name, event.getName()) && this.getAll().equals(event.getAll());
    }

    protected void valudateAttribute(String name, Object value) {
        if (this.clonePolicy == EventClonePolicy.DEEP && !(value instanceof Serializable)) {
            throw new SpongeException("Not serializable attribute can't be deep cloned.");
        }
    }

    public BaseEvent clone() {
        try {
            return (BaseEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException((Throwable)e);
        }
    }

    public String toString() {
        return this.name + ", id=" + this.id + ", time=" + this.time + ", priority=" + this.getPriority() + ", attributes=" + this.getAll();
    }
}

