/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.rule.GenericRuleEventSpec;
import org.openksavi.sponge.core.util.Utils;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.rule.RuleAdapter;
import org.openksavi.sponge.rule.RuleEventSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseKnowledgeBaseInterpreter
implements KnowledgeBaseInterpreter {
    private KnowledgeBaseType type;
    private KnowledgeBaseEngineOperations engineOperations;

    protected BaseKnowledgeBaseInterpreter(KnowledgeBaseEngineOperations engineOperations, KnowledgeBaseType type) {
        this.engineOperations = engineOperations;
        this.type = type;
    }

    public <T extends Processor> T createProcessorInstance(String processorClassName, Class<T> javaClass) {
        return (T)((Processor)this.doCreateInstance(processorClassName, javaClass));
    }

    protected abstract <T> T doCreateInstance(String var1, Class<T> var2);

    public Plugin createPluginInstance(String pluginClassName) {
        return this.doCreateInstance(pluginClassName, Plugin.class);
    }

    public KnowledgeBaseEngineOperations getEngineOperations() {
        return this.engineOperations;
    }

    public KnowledgeBaseType getType() {
        return this.type;
    }

    public RuleEventSpec getRuleEventSpec(Object eventSpecEntry) {
        if (eventSpecEntry == null) {
            throw new SpongeException("Event specification entry cannot be null");
        }
        if (!(eventSpecEntry instanceof RuleEventSpec)) {
            if (eventSpecEntry instanceof String) {
                return this.getCustomRuleEventSpec((String)eventSpecEntry);
            }
            throw new SpongeException("Unknown event specification " + eventSpecEntry + " (type: " + eventSpecEntry.getClass().getName() + ")");
        }
        RuleEventSpec result = (RuleEventSpec)eventSpecEntry;
        return result;
    }

    protected RuleEventSpec getCustomRuleEventSpec(String eventSpecString) {
        if (eventSpecString == null) {
            throw new SpongeException("Event specification is null");
        }
        List mainList = Arrays.stream(eventSpecString.split(":")).map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (mainList.isEmpty()) {
            throw new SpongeException("Event specification is empty");
        }
        if (mainList.size() > 2) {
            throw new SpongeException("Event specification has too many elements separated by ':'");
        }
        ImmutablePair<String, String> nameAlias = this.resolveEventNameAndAlias((String)mainList.get(0));
        EventMode eventMode = RuleAdapter.DEFAULT_MODE;
        if (mainList.size() == 2) {
            try {
                eventMode = EventMode.valueOf((String)((String)mainList.get(1)).toUpperCase());
            }
            catch (Exception e) {
                throw new SpongeException("Event mode is incorrect: " + (String)mainList.get(1));
            }
        }
        return new GenericRuleEventSpec((String)nameAlias.getLeft(), (String)nameAlias.getRight(), eventMode);
    }

    protected ImmutablePair<String, String> resolveEventNameAndAlias(String eventSpecString) {
        if (eventSpecString == null) {
            throw new SpongeException("Event specification is null");
        }
        if (eventSpecString.trim().length() < 1) {
            throw new SpongeException("Event specification is empty");
        }
        StringTokenizer st = new StringTokenizer(eventSpecString, " \t\n\r\f", false);
        String eventName = st.nextToken();
        String eventAlias = st.hasMoreTokens() ? st.nextToken() : eventName;
        return new ImmutablePair((Object)eventName, (Object)eventAlias);
    }

    public <T> T getVariable(String name, Class<T> cls) {
        return (T)this.getVariable(name);
    }

    public Logger getLogger() {
        return LoggerFactory.getLogger((String)Utils.createGlobalLoggerName(this.getEngineOperations()));
    }
}

