/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openksavi.sponge.EventSetProcessorState;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.config.ConfigException;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.kb.BaseKnowledgeBaseInterpreter;
import org.openksavi.sponge.core.kb.CachedScriptClassInstancePovider;
import org.openksavi.sponge.core.util.Utils;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventClonePolicy;
import org.openksavi.sponge.event.EventName;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseScript;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.kb.ScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.rule.EventMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScriptKnowledgeBaseInterpreter
extends BaseKnowledgeBaseInterpreter
implements ScriptKnowledgeBaseInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(BaseScriptKnowledgeBaseInterpreter.class);
    public static final String PROP_PATH_SEPARATOR = ", \t";
    protected Object interpteterSynchro = new Object();
    protected CachedScriptClassInstancePovider cachedScriptClassInstancePovider;

    protected BaseScriptKnowledgeBaseInterpreter(KnowledgeBaseEngineOperations engineOperations, KnowledgeBaseType type) {
        super(engineOperations, type);
        this.prepareInterpreter();
        this.cachedScriptClassInstancePovider = this.createCachedScriptClassInstancePovider();
    }

    protected abstract void prepareInterpreter();

    protected abstract <T> CachedScriptClassInstancePovider createCachedScriptClassInstancePovider();

    @Override
    protected <T> T doCreateInstance(String className, Class<T> javaClass) {
        return this.cachedScriptClassInstancePovider.newInstance(className, javaClass);
    }

    protected final void invalidateCache() {
        this.cachedScriptClassInstancePovider.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(List<KnowledgeBaseScript> scripts) {
        if (scripts.size() > 1) {
            logger.debug("Loading knowledge base '{}' from files: {}.", (Object)scripts.get(0).getKnowledgeBase().getName(), (Object)scripts.stream().map(script -> script.getFileName()).collect(Collectors.joining(", ", "'", "'")));
        }
        Object object = this.interpteterSynchro;
        synchronized (object) {
            scripts.forEach(script -> this.loadKnowledgeBaseScript((KnowledgeBaseScript)script));
        }
    }

    public final void load(String fileName) {
        this.load(fileName, Charset.defaultCharset());
    }

    public final void load(String fileName, String charset) {
        this.load(fileName, Charset.forName(charset));
    }

    public final void load(String fileName, Charset charset) {
        this.load(fileName, charset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(String fileName, Charset charset, boolean required) {
        Object object = this.interpteterSynchro;
        synchronized (object) {
            this.invalidateCache();
            Engine engine = this.getEngineOperations().getEngine();
            try (Reader reader = engine.getKnowledgeBaseFileProvider().getReader(engine, fileName, charset);){
                if (reader != null) {
                    this.doLoad(reader, fileName);
                } else {
                    if (required) {
                        throw new ConfigException("Knowledge base file " + fileName + " not found");
                    }
                    logger.warn("Knowledge base file " + fileName + " not found but is set as optional.");
                }
            }
            catch (IOException e) {
                throw Utils.wrapException("load", e);
            }
        }
    }

    public final void load(KnowledgeBaseScript script) {
        this.load(script.getFileName(), script.getCharset() != null ? Charset.forName(script.getCharset()) : Charset.defaultCharset(), script.isRequired());
    }

    protected void doLoad(Reader reader, String fileName) {
        this.eval(reader, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload(List<KnowledgeBaseScript> scripts) {
        Object object = this.interpteterSynchro;
        synchronized (object) {
            this.doReload(scripts);
        }
    }

    protected void doReload(List<KnowledgeBaseScript> scripts) {
        this.load(scripts);
    }

    private void loadKnowledgeBaseScript(KnowledgeBaseScript script) {
        logger.info("Loading knowledge base '{}' file '{}'.", (Object)script.getKnowledgeBase().getName(), (Object)script.getFileName());
        this.load(script);
    }

    public void onInit() {
        this.invokeOptionalFunction("onInit");
    }

    public void onLoad() {
        if (this.getEngineOperations().getEngine().getConfigurationManager().getAutoEnable()) {
            this.scanToAutoEnable();
        }
        this.invokeOptionalFunction("onLoad");
    }

    public void onStartup() {
        this.invokeOptionalFunction("onStartup");
    }

    public void onShutdown() {
        this.invokeOptionalFunction("onShutdown");
    }

    public void onBeforeReload() {
        this.invokeOptionalFunction("onBeforeReload");
    }

    public void onAfterReload() {
        this.invokeOptionalFunction("onAfterReload");
    }

    public <T> T eval(String expression, Class<T> cls) {
        return (T)this.eval(expression);
    }

    public abstract <T> T eval(Reader var1, String var2);

    protected abstract ScriptKnowledgeBaseInterpreter createInterpreterInstance(Engine var1, KnowledgeBase var2);

    protected List<Class<?>> getStandardImportClasses() {
        return Arrays.asList(EventMode.class, EventClonePolicy.class, Utils.class, SpongeException.class, Event.class, Configuration.class, EventClonePolicy.class, EventSetProcessorState.class, EventName.class, Duration.class, Instant.class, ChronoUnit.class, TimeUnit.class);
    }

    protected boolean isProcessorAbstract(String className) {
        return className.startsWith("Abstract");
    }
}

