/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.openksavi.sponge.core.util.Utils;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.kb.KnowledgeBaseFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKnowledgeBaseFileProvider
implements KnowledgeBaseFileProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultKnowledgeBaseFileProvider.class);

    public Reader getReader(Engine engine, String fileName, Charset charset) throws IOException {
        String home;
        URL configurationFileUrl;
        Reader reader = Utils.getReader(fileName, charset);
        if (reader == null && (configurationFileUrl = engine.getConfigurationManager().getConfigurationFileUrl()) != null) {
            File configFile = FileLocatorUtils.fileFromURL((URL)configurationFileUrl);
            if (configFile != null) {
                String configDir = configFile.getParent();
                if (configDir != null) {
                    reader = Utils.getReader(Paths.get(configDir, fileName).toString(), charset);
                }
            } else {
                logger.warn("Configuration file URL {} cannot be converted to File", (Object)configurationFileUrl);
            }
        }
        if (reader == null && (home = engine.getConfigurationManager().getHome()) != null) {
            reader = Utils.getReader(Paths.get(home, fileName).toString(), charset);
        }
        return reader;
    }
}

