/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.List;
import org.openksavi.sponge.core.BaseEventSetProcessorAdapter;
import org.openksavi.sponge.core.rule.BaseRuleDefinition;
import org.openksavi.sponge.core.rule.GenericRuleEventSpec;
import org.openksavi.sponge.rule.EventCondition;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.rule.Rule;
import org.openksavi.sponge.rule.RuleAdapter;
import org.openksavi.sponge.rule.RuleEventSpec;

public abstract class AbstractRuleAdapter<T extends Rule>
extends BaseEventSetProcessorAdapter<Rule>
implements RuleAdapter {
    protected AbstractRuleAdapter(BaseRuleDefinition definition) {
        super(definition);
    }

    public void setOrdered(boolean ordered) {
        this.getDefinition().setOrdered(ordered);
    }

    public void addJavaConditions(String eventAlias, EventCondition ... conditions) {
        this.getDefinition().addJavaConditions(eventAlias, conditions);
    }

    public void addAllJavaConditions(EventCondition ... conditions) {
        this.getDefinition().addAllJavaConditions(conditions);
    }

    public void addJavaCondition(String eventAlias, EventCondition condition) {
        this.getDefinition().addJavaCondition(eventAlias, condition);
    }

    public List<EventCondition> getConditions(String eventAlias) {
        return this.getDefinition().getConditions(eventAlias);
    }

    @Override
    protected void onDuration() {
        this.runRule();
    }

    protected abstract boolean runRule();

    public void setEventAliases(String ... aliases) {
        this.getDefinition().setEventAliases(aliases);
    }

    public String[] getEventAliases() {
        return this.getDefinition().getEventAliases();
    }

    public String getEventAlias(int index) {
        return this.getDefinition().getEventAlias(index);
    }

    public void setEventModes(EventMode ... modes) {
        this.getDefinition().setEventModes(modes);
    }

    public EventMode[] getEventModes() {
        return this.getDefinition().getEventModes();
    }

    public EventMode getEventMode(int index) {
        return this.getDefinition().getEventMode(index);
    }

    public void setEventSpecs(List<Object> events) {
        String[] eventNames = new String[events.size()];
        String[] eventAliases = new String[events.size()];
        EventMode[] modes = new EventMode[events.size()];
        for (int i = 0; i < events.size(); ++i) {
            RuleEventSpec eventSpec = this.getKnowledgeBase().getInterpreter().getRuleEventSpec(events.get(i));
            eventNames[i] = eventSpec.getEventName();
            eventAliases[i] = eventSpec.getEventAlias();
            modes[i] = eventSpec.getEventMode();
        }
        this.setEventNames(eventNames);
        this.setEventAliases(eventAliases);
        this.setEventModes(modes);
    }

    @Override
    public BaseRuleDefinition getDefinition() {
        return (BaseRuleDefinition)super.getDefinition();
    }

    public int getEventCount() {
        return this.getDefinition().getEventNames().length;
    }

    public RuleEventSpec makeEventSpec(String eventName, String eventAlias, EventMode eventMode) {
        return new GenericRuleEventSpec(eventName, eventAlias, eventMode);
    }

    public RuleEventSpec makeEventSpec(String eventName, EventMode eventMode) {
        return new GenericRuleEventSpec(eventName, eventName, eventMode);
    }

    public RuleEventSpec makeEventSpec(String eventName, String eventAlias) {
        return new GenericRuleEventSpec(eventName, eventAlias, DEFAULT_MODE);
    }

    public RuleEventSpec makeEventSpec(String eventName) {
        return new GenericRuleEventSpec(eventName, eventName, DEFAULT_MODE);
    }
}

