/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.openksavi.sponge.core.BaseEventSetProcessorDefinition;
import org.openksavi.sponge.rule.EventCondition;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.rule.RuleDefinition;

public class BaseRuleDefinition
extends BaseEventSetProcessorDefinition
implements RuleDefinition {
    protected boolean ordered = true;
    protected String[] aliases;
    protected EventMode[] modes;
    protected Map<String, List<EventCondition>> conditions = Collections.synchronizedMap(new LinkedHashMap());

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setEventAliases(String ... aliases) {
        this.aliases = aliases;
    }

    public String[] getEventAliases() {
        return this.aliases;
    }

    public String getEventAlias(int index) {
        return this.aliases[index];
    }

    public void setEventModes(EventMode ... modes) {
        this.modes = modes;
    }

    public EventMode[] getEventModes() {
        return this.modes;
    }

    public EventMode getEventMode(int index) {
        return this.modes[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJavaConditions(String eventAlias, EventCondition ... newConditions) {
        Map<String, List<EventCondition>> map = this.conditions;
        synchronized (map) {
            this.safeGetEventConditions(eventAlias).addAll(Arrays.asList(newConditions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllJavaConditions(EventCondition ... newConditions) {
        Map<String, List<EventCondition>> map = this.conditions;
        synchronized (map) {
            Stream.of(this.aliases).forEachOrdered(alias -> this.addJavaConditions((String)alias, newConditions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addJavaCondition(String eventAlias, EventCondition condition) {
        Map<String, List<EventCondition>> map = this.conditions;
        synchronized (map) {
            this.safeGetEventConditions(eventAlias).add(condition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<EventCondition> safeGetEventConditions(String eventAlias) {
        Map<String, List<EventCondition>> map = this.conditions;
        synchronized (map) {
            List<Object> eventConditions = this.conditions.get(eventAlias);
            if (eventConditions == null) {
                eventConditions = Collections.synchronizedList(new ArrayList());
                this.conditions.put(eventAlias, eventConditions);
            }
            return eventConditions;
        }
    }

    public List<EventCondition> getConditions(String eventAlias) {
        return this.conditions.get(eventAlias);
    }
}

