/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.ListIterator;
import org.apache.commons.lang3.mutable.Mutable;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.rule.AbstractRuleAdapterRuntime;
import org.openksavi.sponge.core.rule.BaseRuleAdapter;
import org.openksavi.sponge.core.rule.RuleAdapterRuntime;
import org.openksavi.sponge.core.util.TreeNode;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.shaded.com.google.common.collect.Iterables;

public class OrderedRuleAdapterRuntime
extends AbstractRuleAdapterRuntime {
    public OrderedRuleAdapterRuntime(BaseRuleAdapter adapter) {
        super(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCandidateForFirstEvent(Event event) {
        TreeNode<RuleAdapterRuntime.NodeValue> newNode = new TreeNode<RuleAdapterRuntime.NodeValue>(new RuleAdapterRuntime.NodeValue(event));
        this.eventTree.setRoot(newNode);
        try {
            boolean bl = this.getExpectedEventIndex(newNode, event) >= 0;
            return bl;
        }
        finally {
            this.eventTree.setRoot(null);
        }
    }

    @Override
    protected int getExpectedEventIndex(TreeNode<RuleAdapterRuntime.NodeValue> node, Event event) {
        String[] eventNames;
        int level = node.getLevel();
        if (level < (eventNames = this.adapter.getEventNames()).length && this.adapter.getKnowledgeBase().getEngineOperations().getEngine().getPatternMatcher().matches(eventNames[level], event.getName())) {
            node.getValue().setIndex(level);
            return level;
        }
        return -1;
    }

    @Override
    protected boolean shouldAddToEventTreeForFlaModes(TreeNode<RuleAdapterRuntime.NodeValue> newNode, Event event) {
        int index;
        int n = index = newNode.getLevel() == 0 ? 0 : this.getExpectedEventIndex(newNode, event);
        if (newNode.getValue().getIndex() == null) {
            newNode.getValue().setIndex(index);
        }
        return index >= 0 && this.checkConditions(newNode);
    }

    @Override
    protected boolean shouldAddToEventTreeForNMode(TreeNode<RuleAdapterRuntime.NodeValue> parentNode, Mutable<TreeNode<RuleAdapterRuntime.NodeValue>> newNodeHolder, Event event) {
        boolean result = false;
        if (this.handleNoneEventHappenedButShouldNot(parentNode, (TreeNode)newNodeHolder.getValue(), event)) {
            return false;
        }
        parentNode.getChildren().subList(1, parentNode.getChildren().size()).clear();
        TreeNode<RuleAdapterRuntime.NodeValue> emptyNode = parentNode.getChildren().get(0);
        if (emptyNode.getValue().getEvent() != null) {
            emptyNode.getValue().setEvent(null);
        }
        this.buildEventTree(emptyNode, event);
        if (emptyNode.hasChildren()) {
            result = true;
        }
        newNodeHolder.setValue(emptyNode);
        return result;
    }

    @Override
    protected boolean shouldRunRule() {
        EventMode lastMode = this.adapter.getEventMode(this.adapter.getEventModes().length - 1);
        if (lastMode == EventMode.FIRST || lastMode == EventMode.ALL) {
            return true;
        }
        return this.adapter.isDurationTriggered();
    }

    @Override
    protected boolean runRuleForNonFinalNode(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        int maxLevel = this.adapter.getEventCount() - 1;
        boolean fired = false;
        EventMode eventMode = this.adapter.getEventModes()[node.getLevel() + 1];
        switch (eventMode) {
            case FIRST: {
                TreeNode<RuleAdapterRuntime.NodeValue> child;
                if (!node.hasChildren() || (child = node.getChildren().get(0)) == null) break;
                return this.runRule(child);
            }
            case LAST: {
                TreeNode<RuleAdapterRuntime.NodeValue> child;
                if (!node.hasChildren() || (child = Iterables.getLast(node.getChildren())) == null) break;
                return this.runRule(child);
            }
            case ALL: {
                ListIterator<TreeNode<RuleAdapterRuntime.NodeValue>> treeNodeIterator = node.getChildren().listIterator();
                while (treeNodeIterator.hasNext()) {
                    TreeNode child = (TreeNode)treeNodeIterator.next();
                    if (this.runRule(child)) {
                        fired = true;
                    }
                    if (child.getValue() != null) continue;
                    treeNodeIterator.remove();
                }
                break;
            }
            case NONE: {
                TreeNode<RuleAdapterRuntime.NodeValue> child;
                if (this.adapter.isDurationTriggered() && !node.hasChildren() && node.getLevel() + 1 == maxLevel) {
                    node.addChild(new TreeNode<RuleAdapterRuntime.NodeValue>(new RuleAdapterRuntime.NodeValue(null)));
                }
                if (!node.hasChildren() || (child = node.getChildren().get(0)) == null) break;
                return this.runRule(child);
            }
            default: {
                throw new SpongeException("Unsupported value: " + eventMode);
            }
        }
        return fired;
    }

    @Override
    protected int getEventIndex(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        return node.getLevel();
    }

    @Override
    protected boolean isLeafLevel(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        return node.getLevel() == this.adapter.getEventCount() - 1;
    }

    @Override
    public void validate() {
        EventMode firstMode = this.adapter.getEventModes()[0];
        if (firstMode != EventMode.FIRST) {
            throw this.adapter.createValidationException("The mode of the first event in the sequence must be " + EventMode.FIRST + ".");
        }
        EventMode lastMode = this.adapter.getEventModes()[this.adapter.getEventModes().length - 1];
        if (lastMode == null) {
            throw this.adapter.createValidationException("The mode of the last event in the sequence is not set");
        }
        if (!(lastMode != EventMode.LAST && lastMode != EventMode.NONE || this.adapter.hasDuration())) {
            throw this.adapter.createValidationException("If the mode of the last event in the sequence is " + lastMode + " a duration should be set.");
        }
    }
}

