/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.java;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.engine.BaseEngine;
import org.openksavi.sponge.core.kb.BaseKnowledgeBaseInterpreter;
import org.openksavi.sponge.core.kb.GenericKnowledgeBaseType;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.java.JavaKnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseType;

public class JavaKnowledgeBaseInterpreter
extends BaseKnowledgeBaseInterpreter {
    public static final KnowledgeBaseType TYPE = new GenericKnowledgeBaseType("java", "class");
    protected Map<String, Object> variables = Collections.synchronizedMap(new LinkedHashMap());

    public JavaKnowledgeBaseInterpreter(Engine engine, KnowledgeBase knowledgeBase) {
        super(new JavaKnowledgeBaseEngineOperations((BaseEngine)engine, knowledgeBase), TYPE);
    }

    public Object invokeMethod(Object target, String name, Object ... args) {
        try {
            return MethodUtils.invokeMethod((Object)target, (String)name, (Object[])args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new SpongeException((Throwable)e);
        }
    }

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    public Object getVariable(String name) {
        if (!this.variables.containsKey(name)) {
            throw new SpongeException("Variable " + name + " not found");
        }
        return this.variables.get(name);
    }

    public boolean existsVariable(String name) {
        return this.variables.containsKey(name);
    }

    public boolean isKnowledgeBaseException(Throwable exception) {
        return false;
    }

    public Throwable getJavaException(Throwable knowledgeBaseException) {
        return knowledgeBaseException;
    }

    public String getScriptKnowledgeBaseProcessorClassName(Object processorClass) {
        return null;
    }

    @Override
    protected <T> T doCreateInstance(String className, Class<T> javaClass) {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SpongeException((Throwable)e);
        }
    }
}

