/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.shaded.org.quartz.core;

import org.openksavi.sponge.shaded.org.quartz.JobKey;
import org.openksavi.sponge.shaded.org.quartz.SchedulerException;
import org.openksavi.sponge.shaded.org.quartz.Trigger;
import org.openksavi.sponge.shaded.org.quartz.core.QuartzScheduler;
import org.openksavi.sponge.shaded.org.quartz.core.QuartzSchedulerThread;
import org.openksavi.sponge.shaded.org.quartz.spi.SchedulerSignaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerSignalerImpl
implements SchedulerSignaler {
    Logger log = LoggerFactory.getLogger(SchedulerSignalerImpl.class);
    protected QuartzScheduler sched;
    protected QuartzSchedulerThread schedThread;

    public SchedulerSignalerImpl(QuartzScheduler sched, QuartzSchedulerThread schedThread) {
        this.sched = sched;
        this.schedThread = schedThread;
        this.log.info("Initialized Scheduler Signaller of type: " + this.getClass());
    }

    @Override
    public void notifyTriggerListenersMisfired(Trigger trigger) {
        try {
            this.sched.notifyTriggerListenersMisfired(trigger);
        }
        catch (SchedulerException se) {
            this.sched.getLog().error("Error notifying listeners of trigger misfire.", (Throwable)se);
            this.sched.notifySchedulerListenersError("Error notifying listeners of trigger misfire.", se);
        }
    }

    @Override
    public void notifySchedulerListenersFinalized(Trigger trigger) {
        this.sched.notifySchedulerListenersFinalized(trigger);
    }

    @Override
    public void signalSchedulingChange(long candidateNewNextFireTime) {
        this.schedThread.signalSchedulingChange(candidateNewNextFireTime);
    }

    @Override
    public void notifySchedulerListenersJobDeleted(JobKey jobKey) {
        this.sched.notifySchedulerListenersJobDeleted(jobKey);
    }

    @Override
    public void notifySchedulerListenersError(String string, SchedulerException jpe) {
        this.sched.notifySchedulerListenersError(string, jpe);
    }
}

